/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.upgrade;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutVersionManager;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class OMLayoutFeatureAspect {
    public static final String GET_VERSION_MANAGER_METHOD_NAME = "getOmVersionManager";
    private static final Logger LOG = LoggerFactory.getLogger(OMLayoutFeatureAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ OMLayoutFeatureAspect ajc$perSingletonInstance;

    static {
        try {
            OMLayoutFeatureAspect.ajc$perSingletonInstance = new OMLayoutFeatureAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Before(value="@annotation(DisallowedUntilLayoutVersion) && execution(* *(..))")
    public void checkLayoutFeature(JoinPoint joinPoint) throws IOException {
        String featureName = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(DisallowedUntilLayoutVersion.class).value().name();
        OMLayoutVersionManager lvm = null;
        if (joinPoint.getTarget() instanceof OzoneManagerRequestHandler) {
            OzoneManager ozoneManager = ((OzoneManagerRequestHandler)joinPoint.getTarget()).getOzoneManager();
            lvm = ozoneManager.getVersionManager();
        } else {
            try {
                Method method = joinPoint.getTarget().getClass().getMethod(GET_VERSION_MANAGER_METHOD_NAME, new Class[0]);
                lvm = (LayoutVersionManager)method.invoke(joinPoint.getTarget(), new Object[0]);
            }
            catch (Exception exception) {
                lvm = new OMLayoutVersionManager();
            }
        }
        this.checkIsAllowed(joinPoint.getSignature().toShortString(), (LayoutVersionManager)lvm, featureName);
    }

    private void checkIsAllowed(String operationName, LayoutVersionManager lvm, String featureName) throws OMException {
        if (!lvm.isAllowed(featureName)) {
            LayoutFeature layoutFeature = lvm.getFeature(featureName);
            throw new OMException(String.format("Operation %s cannot be invoked before finalization. It belongs to the layout feature %s, whose layout version is %d. Current Layout version is %d", operationName, layoutFeature.name(), layoutFeature.layoutVersion(), lvm.getMetadataLayoutVersion()), OMException.ResultCodes.NOT_SUPPORTED_OPERATION);
        }
    }

    @Pointcut(value="execution(* org.apache.hadoop.ozone.om.request.OMClientRequest+.preExecute(..)) && @this(org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion)")
    public /* synthetic */ void omRequestPointCut() {
    }

    @Before(value="omRequestPointCut()")
    public void beforeRequestApplyTxn(JoinPoint joinPoint) throws OMException {
        BelongsToLayoutVersion annotation = joinPoint.getTarget().getClass().getAnnotation(BelongsToLayoutVersion.class);
        if (annotation == null) {
            return;
        }
        Object[] args = joinPoint.getArgs();
        OzoneManager om = (OzoneManager)args[0];
        OMLayoutFeature lf = annotation.value();
        this.checkIsAllowed(joinPoint.getTarget().getClass().getSimpleName(), (LayoutVersionManager)om.getVersionManager(), lf.name());
    }

    public static OMLayoutFeatureAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

