/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.server.http.HttpConfig;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RocksDBCheckpoint;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerSnapshotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerSnapshotProvider.class);
    private final File omSnapshotDir;
    private Map<String, OMNodeDetails> peerNodesMap;
    private final HttpConfig.Policy httpPolicy;
    private final boolean spnegoEnabled;
    private final URLConnectionFactory connectionFactory;
    private static final String OM_SNAPSHOT_DB = "om.snapshot.db";

    public OzoneManagerSnapshotProvider(MutableConfigurationSource conf, File omRatisSnapshotDir, Map<String, OMNodeDetails> peerNodeDetails) {
        LOG.info("Initializing OM Snapshot Provider");
        this.omSnapshotDir = omRatisSnapshotDir;
        this.peerNodesMap = new HashMap<String, OMNodeDetails>();
        this.peerNodesMap.putAll(peerNodeDetails);
        this.httpPolicy = HttpConfig.getHttpPolicy((MutableConfigurationSource)conf);
        this.spnegoEnabled = conf.get("ozone.om.http.auth.type", "simple").equals("kerberos");
        TimeUnit connectionTimeoutUnit = OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_CONNECTION_TIMEOUT_DEFAULT.getUnit();
        int connectionTimeoutMS = (int)conf.getTimeDuration("ozone.om.snapshot.provider.connection.timeout", OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_CONNECTION_TIMEOUT_DEFAULT.getDuration(), connectionTimeoutUnit);
        TimeUnit requestTimeoutUnit = OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_REQUEST_TIMEOUT_DEFAULT.getUnit();
        int requestTimeoutMS = (int)conf.getTimeDuration("ozone.om.snapshot.provider.request.timeout", OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_REQUEST_TIMEOUT_DEFAULT.getDuration(), requestTimeoutUnit);
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((int)connectionTimeoutMS, (int)requestTimeoutMS, (Configuration)LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)conf));
    }

    public DBCheckpoint getOzoneManagerDBSnapshot(String leaderOMNodeID) throws IOException {
        String snapshotTime = Long.toString(System.currentTimeMillis());
        String snapshotFileName = "om.db-" + leaderOMNodeID + "-" + snapshotTime;
        String snapshotFilePath = Paths.get(this.omSnapshotDir.getAbsolutePath(), snapshotFileName).toFile().getAbsolutePath();
        File targetFile = new File(String.valueOf(snapshotFileName) + ".tar.gz");
        String omCheckpointUrl = this.peerNodesMap.get(leaderOMNodeID).getOMDBCheckpointEnpointUrl(this.httpPolicy.isHttpEnabled());
        LOG.info("Downloading latest checkpoint from Leader OM {}. Checkpoint URL: {}", (Object)leaderOMNodeID, (Object)omCheckpointUrl);
        SecurityUtil.doAsCurrentUser(() -> {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.connectionFactory.openConnection(new URL(omCheckpointUrl), this.spnegoEnabled);
            httpURLConnection.connect();
            int errorCode = httpURLConnection.getResponseCode();
            if (errorCode != 200 && errorCode != 201) {
                throw new IOException("Unexpected exception when trying to reach OM to download latest checkpoint. Checkpoint URL: " + omCheckpointUrl + ". ErrorCode: " + errorCode);
            }
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        });
        Path untarredDbDir = Paths.get(snapshotFilePath, new String[0]);
        FileUtil.unTar((File)targetFile, (File)untarredDbDir.toFile());
        FileUtils.deleteQuietly((File)targetFile);
        LOG.info("Successfully downloaded latest checkpoint from leader OM: {}", (Object)leaderOMNodeID);
        RocksDBCheckpoint omCheckpoint = new RocksDBCheckpoint(untarredDbDir);
        return omCheckpoint;
    }

    public void stop() {
        if (this.connectionFactory != null) {
            this.connectionFactory.destroy();
        }
    }

    public void addNewPeerNode(OMNodeDetails newOMNode) {
        this.peerNodesMap.put(newOMNode.getNodeId(), newOMNode);
    }
}

