/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.volume;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;

@CleanupTableInfo(cleanupTables={"volumeTable"})
public class OMVolumeDeleteResponse
extends OMClientResponse {
    private String volume;
    private String owner;
    private OzoneManagerStorageProtos.PersistedUserVolumeInfo updatedVolumeList;

    public OMVolumeDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String volume, @Nonnull String owner, @Nonnull OzoneManagerStorageProtos.PersistedUserVolumeInfo updatedVolumeList) {
        super(omResponse);
        this.volume = volume;
        this.owner = owner;
        this.updatedVolumeList = updatedVolumeList;
    }

    public OMVolumeDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String dbUserKey = omMetadataManager.getUserKey(this.owner);
        OzoneManagerStorageProtos.PersistedUserVolumeInfo volumeList = this.updatedVolumeList;
        if (this.updatedVolumeList.getVolumeNamesList().size() == 0) {
            omMetadataManager.getUserTable().deleteWithBatch(batchOperation, (Object)dbUserKey);
        } else {
            omMetadataManager.getUserTable().putWithBatch(batchOperation, (Object)dbUserKey, (Object)volumeList);
        }
        omMetadataManager.getVolumeTable().deleteWithBatch(batchOperation, (Object)omMetadataManager.getVolumeKey(this.volume));
    }
}

