/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.security;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"s3SecretTable"})
public class S3GetSecretResponse
extends OMClientResponse {
    private S3SecretValue s3SecretValue;

    public S3GetSecretResponse(@Nullable S3SecretValue s3SecretValue, @Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.s3SecretValue = s3SecretValue;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.s3SecretValue != null && this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            omMetadataManager.getS3SecretTable().putWithBatch(batchOperation, (Object)this.s3SecretValue.getKerberosID(), (Object)this.s3SecretValue);
        }
    }
}

