/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCompleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openFileTable", "fileTable", "deletedTable", "multipartInfoTable"})
public class S3MultipartUploadCompleteResponseWithFSO
extends S3MultipartUploadCompleteResponse {
    public S3MultipartUploadCompleteResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String multipartKey, @Nonnull String multipartOpenKey, @Nonnull OmKeyInfo omKeyInfo, @Nonnull List<OmKeyInfo> unUsedParts) {
        super(omResponse, multipartKey, multipartOpenKey, omKeyInfo, unUsedParts);
    }

    public S3MultipartUploadCompleteResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    protected String addToKeyTable(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneKey = omMetadataManager.getOzoneKey(this.getOmKeyInfo().getVolumeName(), this.getOmKeyInfo().getBucketName(), this.getOmKeyInfo().getKeyName());
        OMFileRequest.addToFileTable(omMetadataManager, batchOperation, this.getOmKeyInfo());
        return ozoneKey;
    }
}

