/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "keyTable", "deletedTable", "multipartInfoTable"})
public class S3MultipartUploadCompleteResponse
extends OMClientResponse {
    private String multipartKey;
    private String multipartOpenKey;
    private OmKeyInfo omKeyInfo;
    private List<OmKeyInfo> partsUnusedList;

    public S3MultipartUploadCompleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String multipartKey, @Nonnull String multipartOpenKey, @Nonnull OmKeyInfo omKeyInfo, @Nonnull List<OmKeyInfo> unUsedParts) {
        super(omResponse);
        this.partsUnusedList = unUsedParts;
        this.multipartKey = multipartKey;
        this.multipartOpenKey = multipartOpenKey;
        this.omKeyInfo = omKeyInfo;
    }

    public S3MultipartUploadCompleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).deleteWithBatch(batchOperation, (Object)this.multipartOpenKey);
        omMetadataManager.getMultipartInfoTable().deleteWithBatch(batchOperation, (Object)this.multipartKey);
        String ozoneKey = this.addToKeyTable(omMetadataManager, batchOperation);
        if (!this.partsUnusedList.isEmpty()) {
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)ozoneKey);
            if (repeatedOmKeyInfo == null) {
                repeatedOmKeyInfo = new RepeatedOmKeyInfo(this.partsUnusedList);
            } else {
                for (OmKeyInfo unUsedPart : this.partsUnusedList) {
                    repeatedOmKeyInfo.addOmKeyInfo(unUsedPart);
                }
            }
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)ozoneKey, (Object)repeatedOmKeyInfo);
        }
    }

    protected String addToKeyTable(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneKey = omMetadataManager.getOzoneKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName());
        omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)ozoneKey, (Object)this.omKeyInfo);
        return ozoneKey;
    }

    protected String getMultipartKey() {
        return this.multipartKey;
    }

    protected OmKeyInfo getOmKeyInfo() {
        return this.omKeyInfo;
    }

    protected List<OmKeyInfo> getPartsUnusedList() {
        return this.partsUnusedList;
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

