/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3InitiateMultipartUploadResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"directoryTable", "openFileTable", "multipartInfoTable"})
public class S3InitiateMultipartUploadResponseWithFSO
extends S3InitiateMultipartUploadResponse {
    private List<OmDirectoryInfo> parentDirInfos;
    private String mpuDBKey;

    public S3InitiateMultipartUploadResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmMultipartKeyInfo omMultipartKeyInfo, @Nonnull OmKeyInfo omKeyInfo, @Nonnull String mpuDBKey, @Nonnull List<OmDirectoryInfo> parentDirInfos) {
        super(omResponse, omMultipartKeyInfo, omKeyInfo);
        this.parentDirInfos = parentDirInfos;
        this.mpuDBKey = mpuDBKey;
    }

    public S3InitiateMultipartUploadResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.parentDirInfos != null) {
            for (OmDirectoryInfo parentDirInfo : this.parentDirInfos) {
                String parentKey = parentDirInfo.getPath();
                omMetadataManager.getDirectoryTable().putWithBatch(batchOperation, (Object)parentKey, (Object)parentDirInfo);
            }
        }
        OMFileRequest.addToOpenFileTable(omMetadataManager, batchOperation, this.getOmKeyInfo(), this.getOmMultipartKeyInfo().getUploadID());
        omMetadataManager.getMultipartInfoTable().putWithBatch(batchOperation, (Object)this.mpuDBKey, (Object)this.getOmMultipartKeyInfo());
    }
}

