/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key.acl;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.jetbrains.annotations.NotNull;

@CleanupTableInfo(cleanupTables={"fileTable", "directoryTable"})
public class OMKeyAclResponseWithFSO
extends OMKeyAclResponse {
    private boolean isDirectory;

    public OMKeyAclResponseWithFSO(@NotNull OzoneManagerProtocolProtos.OMResponse omResponse, @NotNull OmKeyInfo omKeyInfo, boolean isDirectory) {
        super(omResponse, omKeyInfo);
        this.isDirectory = isDirectory;
    }

    public OMKeyAclResponseWithFSO(@NotNull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneDbKey = omMetadataManager.getOzonePathKey(this.getOmKeyInfo().getParentObjectID(), this.getOmKeyInfo().getFileName());
        if (this.isDirectory) {
            OmDirectoryInfo dirInfo = OMFileRequest.getDirectoryInfo(this.getOmKeyInfo());
            omMetadataManager.getDirectoryTable().putWithBatch(batchOperation, (Object)ozoneDbKey, (Object)dirInfo);
        } else {
            omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)ozoneDbKey, (Object)this.getOmKeyInfo());
        }
    }
}

