/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key.acl;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"keyTable"})
public class OMKeyAclResponse
extends OMClientResponse {
    private OmKeyInfo omKeyInfo;

    public OMKeyAclResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo) {
        super(omResponse);
        this.omKeyInfo = omKeyInfo;
    }

    public OMKeyAclResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String dbKey = omMetadataManager.getOzoneKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName());
        omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)dbKey, (Object)this.omKeyInfo);
    }

    public OmKeyInfo getOmKeyInfo() {
        return this.omKeyInfo;
    }
}

