/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"keyTable"})
public class OMTrashRecoverResponse
extends OMClientResponse {
    private OmKeyInfo omKeyInfo;

    public OMTrashRecoverResponse(@Nullable OmKeyInfo omKeyInfo, @Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.omKeyInfo = omKeyInfo;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String trashKey = omMetadataManager.getOzoneKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName());
        RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)trashKey);
        this.omKeyInfo = OmUtils.prepareKeyForRecover((OmKeyInfo)this.omKeyInfo, (RepeatedOmKeyInfo)repeatedOmKeyInfo);
        omMetadataManager.getDeletedTable().deleteWithBatch(batchOperation, (Object)this.omKeyInfo.getKeyName());
        omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)trashKey, (Object)this.omKeyInfo);
    }
}

