/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CleanupTableInfo(cleanupTables={"deletedTable", "deletedDirectoryTable", "directoryTable", "fileTable"})
public class OMPathsPurgeResponseWithFSO
extends OMClientResponse {
    private static final Logger LOG = LoggerFactory.getLogger(OMPathsPurgeResponseWithFSO.class);
    private List<OzoneManagerProtocolProtos.KeyInfo> markDeletedDirList;
    private List<String> dirList;
    private List<OzoneManagerProtocolProtos.KeyInfo> fileList;
    private boolean isRatisEnabled;

    public OMPathsPurgeResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull List<OzoneManagerProtocolProtos.KeyInfo> markDeletedDirs, @Nonnull List<OzoneManagerProtocolProtos.KeyInfo> files, @Nonnull List<String> dirs, boolean isRatisEnabled) {
        super(omResponse);
        this.markDeletedDirList = markDeletedDirs;
        this.dirList = dirs;
        this.fileList = files;
        this.isRatisEnabled = isRatisEnabled;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneDbKey;
        OmKeyInfo keyInfo;
        for (OzoneManagerProtocolProtos.KeyInfo keyInfo2 : this.markDeletedDirList) {
            keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)keyInfo2);
            ozoneDbKey = omMetadataManager.getOzonePathKey(keyInfo.getParentObjectID(), keyInfo.getFileName());
            omMetadataManager.getDeletedDirTable().putWithBatch(batchOperation, (Object)ozoneDbKey, (Object)keyInfo);
            omMetadataManager.getDirectoryTable().deleteWithBatch(batchOperation, (Object)ozoneDbKey);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("markDeletedDirList KeyName: {}, DBKey: {}", (Object)keyInfo.getKeyName(), (Object)ozoneDbKey);
        }
        for (String string : this.dirList) {
            omMetadataManager.getDeletedDirTable().deleteWithBatch(batchOperation, (Object)string);
            if (!LOG.isDebugEnabled()) continue;
            LOG.info("Purge Deleted Directory DBKey: {}", (Object)string);
        }
        for (OzoneManagerProtocolProtos.KeyInfo keyInfo3 : this.fileList) {
            keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)keyInfo3);
            ozoneDbKey = omMetadataManager.getOzonePathKey(keyInfo.getParentObjectID(), keyInfo.getFileName());
            omMetadataManager.getKeyTable().deleteWithBatch(batchOperation, (Object)ozoneDbKey);
            if (LOG.isDebugEnabled()) {
                LOG.info("Move keyName:{} to DeletedTable DBKey: {}", (Object)keyInfo.getKeyName(), (Object)ozoneDbKey);
            }
            RepeatedOmKeyInfo repeatedOmKeyInfo = null;
            repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)keyInfo, repeatedOmKeyInfo, (long)keyInfo.getUpdateID(), (boolean)this.isRatisEnabled);
            String deletedKey = omMetadataManager.getOzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName());
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)deletedKey, (Object)repeatedOmKeyInfo);
        }
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

