/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMOpenKeysDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMOpenKeysDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMOpenKeysDeleteRequest.class);

    public OMOpenKeysDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        HashMap<String, OmKeyInfo> deletedOpenKeys;
        OMClientRequest.Result result;
        OMOpenKeysDeleteResponse omClientResponse;
        long numSubmittedOpenKeys;
        OzoneManagerProtocolProtos.DeleteOpenKeysRequest deleteOpenKeysRequest;
        OMMetrics omMetrics;
        block7: {
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumOpenKeyDeleteRequests();
            deleteOpenKeysRequest = this.getOmRequest().getDeleteOpenKeysRequest();
            List submittedOpenKeyBuckets = deleteOpenKeysRequest.getOpenKeysPerBucketList();
            numSubmittedOpenKeys = 0L;
            for (OzoneManagerProtocolProtos.OpenKeyBucket keyBucket : submittedOpenKeyBuckets) {
                numSubmittedOpenKeys += (long)keyBucket.getKeysCount();
            }
            LOG.debug("{} open keys submitted for deletion.", (Object)numSubmittedOpenKeys);
            omMetrics.incNumOpenKeysSubmittedForDeletion(numSubmittedOpenKeys);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            IOException exception = null;
            omClientResponse = null;
            result = null;
            deletedOpenKeys = new HashMap<String, OmKeyInfo>();
            try {
                try {
                    for (OzoneManagerProtocolProtos.OpenKeyBucket openKeyBucket : submittedOpenKeyBuckets) {
                        Map<String, OmKeyInfo> deleted = this.updateOpenKeyTableCache(ozoneManager, trxnLogIndex, openKeyBucket);
                        deletedOpenKeys.putAll(deleted);
                    }
                    omClientResponse = new OMOpenKeysDeleteResponse(omResponse.build(), deletedOpenKeys, ozoneManager.isRatisEnabled());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMOpenKeysDeleteResponse(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        }
        this.processResults(omMetrics, numSubmittedOpenKeys, deletedOpenKeys.size(), deleteOpenKeysRequest, result);
        return omClientResponse;
    }

    private void processResults(OMMetrics omMetrics, long numSubmittedOpenKeys, long numDeletedOpenKeys, OzoneManagerProtocolProtos.DeleteOpenKeysRequest request, OMClientRequest.Result result) {
        switch (result) {
            case SUCCESS: {
                LOG.debug("Deleted {} open keys out of {} submitted keys.", (Object)numDeletedOpenKeys, (Object)numSubmittedOpenKeys);
                break;
            }
            case FAILURE: {
                omMetrics.incNumOpenKeyDeleteRequestFails();
                LOG.error("Failure occurred while trying to delete {} submitted open keys.", (Object)numSubmittedOpenKeys);
                break;
            }
            default: {
                LOG.error("Unrecognized result for OMOpenKeysDeleteRequest: {}", (Object)request);
            }
        }
    }

    private Map<String, OmKeyInfo> updateOpenKeyTableCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerProtocolProtos.OpenKeyBucket keysPerBucket) throws IOException {
        HashMap<String, OmKeyInfo> deletedKeys = new HashMap<String, OmKeyInfo>();
        boolean acquiredLock = false;
        String volumeName = keysPerBucket.getVolumeName();
        String bucketName = keysPerBucket.getBucketName();
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        try {
            acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            for (OzoneManagerProtocolProtos.OpenKey key : keysPerBucket.getKeysList()) {
                String fullKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, key.getName(), key.getClientID());
                OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)fullKeyName);
                if (omKeyInfo != null) {
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    deletedKeys.put(fullKeyName, omKeyInfo);
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)fullKeyName), new CacheValue(Optional.absent(), trxnLogIndex));
                    ozoneManager.getMetrics().incNumOpenKeysDeleted();
                    LOG.debug("Open key {} deleted.", (Object)fullKeyName);
                    continue;
                }
                LOG.debug("Key {} was not deleted, as it was not found in the open key table.", (Object)fullKeyName);
            }
        }
        catch (Throwable throwable) {
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
            throw throwable;
        }
        if (acquiredLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        return deletedKeys;
    }
}

