/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OMKeyRenameResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"fileTable", "directoryTable"})
public class OMKeyRenameResponseWithFSO
extends OMKeyRenameResponse {
    private boolean isRenameDirectory;

    public OMKeyRenameResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String fromKeyName, String toKeyName, @Nonnull OmKeyInfo renameKeyInfo, boolean isRenameDirectory) {
        super(omResponse, fromKeyName, toKeyName, renameKeyInfo);
        this.isRenameDirectory = isRenameDirectory;
    }

    public OMKeyRenameResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.isRenameDirectory) {
            omMetadataManager.getDirectoryTable().deleteWithBatch(batchOperation, (Object)this.getFromKeyName());
            OmDirectoryInfo renameDirInfo = OMFileRequest.getDirectoryInfo(this.getRenameKeyInfo());
            omMetadataManager.getDirectoryTable().putWithBatch(batchOperation, (Object)this.getToKeyName(), (Object)renameDirInfo);
        } else {
            omMetadataManager.getKeyTable().deleteWithBatch(batchOperation, (Object)this.getFromKeyName());
            omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)this.getToKeyName(), (Object)this.getRenameKeyInfo());
        }
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

