/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OMKeyDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"fileTable", "directoryTable", "deletedTable", "deletedDirectoryTable"})
public class OMKeyDeleteResponseWithFSO
extends OMKeyDeleteResponse {
    private boolean isDeleteDirectory;
    private String keyName;

    public OMKeyDeleteResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String keyName, @Nonnull OmKeyInfo omKeyInfo, boolean isRatisEnabled, @Nonnull OmBucketInfo omBucketInfo, @Nonnull boolean isDeleteDirectory) {
        super(omResponse, omKeyInfo, isRatisEnabled, omBucketInfo);
        this.keyName = keyName;
        this.isDeleteDirectory = isDeleteDirectory;
    }

    public OMKeyDeleteResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneDbKey = omMetadataManager.getOzonePathKey(this.getOmKeyInfo().getParentObjectID(), this.getOmKeyInfo().getFileName());
        if (this.isDeleteDirectory) {
            omMetadataManager.getDirectoryTable().deleteWithBatch(batchOperation, (Object)ozoneDbKey);
            OmKeyInfo omKeyInfo = this.getOmKeyInfo();
            omKeyInfo.setKeyName(this.keyName);
            omMetadataManager.getDeletedDirTable().putWithBatch(batchOperation, (Object)ozoneDbKey, (Object)omKeyInfo);
        } else {
            Table keyTable = omMetadataManager.getKeyTable();
            OmKeyInfo omKeyInfo = this.getOmKeyInfo();
            omKeyInfo.setKeyName(this.keyName);
            String deletedKey = omMetadataManager.getOzoneKey(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), omKeyInfo.getKeyName());
            this.addDeletionToBatch(omMetadataManager, batchOperation, keyTable, ozoneDbKey, deletedKey, omKeyInfo);
        }
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.getOmBucketInfo().getVolumeName(), this.getOmBucketInfo().getBucketName()), (Object)this.getOmBucketInfo());
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

