/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OMAllocateBlockResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openFileTable"})
public class OMAllocateBlockResponseWithFSO
extends OMAllocateBlockResponse {
    public OMAllocateBlockResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, long clientID, @Nonnull OmBucketInfo omBucketInfo) {
        super(omResponse, omKeyInfo, clientID, omBucketInfo);
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }

    public OMAllocateBlockResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        OMFileRequest.addToOpenFileTable(omMetadataManager, batchOperation, this.getOmKeyInfo(), this.getClientID());
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.getOmKeyInfo().getVolumeName(), this.getOmKeyInfo().getBucketName()), (Object)this.getOmBucketInfo());
    }
}

