/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume.acl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.scm.storage.CheckedBiFunction;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeAclRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeAclOpResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeAddAclRequest
extends OMVolumeAclRequest {
    private static final Logger LOG;
    private static CheckedBiFunction<List<OzoneAcl>, OmVolumeArgs, IOException> volumeAddAclOp;
    private List<OzoneAcl> ozoneAcls;
    private String volumeName;
    private OzoneObj obj;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMVolumeAddAclRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMVolumeAddAclRequest.class);
        volumeAddAclOp = (acls, volArgs) -> {
            boolean bl = volArgs.addAcl((OzoneAcl)acls.get(0));
        };
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.AddAclRequest.Builder addAclRequestBuilder = this.getOmRequest().getAddAclRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setAddAclRequest(addAclRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    public OMVolumeAddAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, volumeAddAclOp);
        OzoneManagerProtocolProtos.AddAclRequest addAclRequest = this.getOmRequest().getAddAclRequest();
        Preconditions.checkNotNull((Object)addAclRequest);
        this.ozoneAcls = Lists.newArrayList((Object[])new OzoneAcl[]{OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)addAclRequest.getAcl())});
        this.obj = OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)addAclRequest.getObj());
        this.volumeName = this.obj.getPath().substring(1);
    }

    @Override
    public List<OzoneAcl> getAcls() {
        return this.ozoneAcls;
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    private OzoneAcl getAcl() {
        return this.ozoneAcls.get(0);
    }

    @Override
    OzoneObj getObject() {
        return this.obj;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmVolumeArgs omVolumeArgs, boolean aclApplied) {
        omResponse.setAddAclResponse(OzoneManagerProtocolProtos.AddAclResponse.newBuilder().setResponse(aclApplied).build());
        return new OMVolumeAclOpResponse(omResponse.build(), omVolumeArgs);
    }

    @Override
    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, IOException ex) {
        return new OMVolumeAclOpResponse(this.createErrorOMResponse(omResponse, ex));
    }

    @Override
    void onComplete(OMClientRequest.Result result, IOException ex, long trxnLogIndex, AuditLogger auditLogger, Map<String, String> auditMap) {
        switch (result) {
            case SUCCESS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Add acl: {} to volume: {} success!", (Object)this.getAcl(), (Object)this.getVolumeName());
                break;
            }
            case FAILURE: {
                LOG.error("Add acl {} to volume {} failed!", new Object[]{this.getAcl(), this.getVolumeName(), ex});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMVolumeAddAclRequest: {}", (Object)this.getOmRequest());
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.ADD_ACL, auditMap, ex, this.getOmRequest().getUserInfo()));
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        ozoneManager.getMetrics().incNumAddAcl();
        return super.validateAndUpdateCache(ozoneManager, trxnLogIndex, omDoubleBufferHelper);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMVolumeAddAclRequest.java", OMVolumeAddAclRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeAddAclRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 60);
    }
}

