/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeCreateResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeCreateRequest
extends OMVolumeRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMVolumeCreateRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMVolumeCreateRequest.class);
    }

    public OMVolumeCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.VolumeInfo volumeInfo = this.getOmRequest().getCreateVolumeRequest().getVolumeInfo();
        OmUtils.validateVolumeName((String)volumeInfo.getVolume());
        long initialTime = Time.now();
        OzoneManagerProtocolProtos.VolumeInfo updatedVolumeInfo = volumeInfo.toBuilder().setCreationTime(initialTime).setModificationTime(initialTime).build();
        return this.getOmRequest().toBuilder().setCreateVolumeRequest(OzoneManagerProtocolProtos.CreateVolumeRequest.newBuilder().setVolumeInfo(updatedVolumeInfo)).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        Map auditMap;
        OMClientResponse omClientResponse;
        IOException exception;
        String owner;
        String volume;
        OMMetrics omMetrics;
        block18: {
            OzoneManagerProtocolProtos.CreateVolumeRequest createVolumeRequest = this.getOmRequest().getCreateVolumeRequest();
            Preconditions.checkNotNull((Object)createVolumeRequest);
            OzoneManagerProtocolProtos.VolumeInfo volumeInfo = createVolumeRequest.getVolumeInfo();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeCreates();
            volume = volumeInfo.getVolume();
            owner = volumeInfo.getOwnerName();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredVolumeLock = false;
            boolean acquiredUserLock = false;
            exception = null;
            omClientResponse = null;
            OmVolumeArgs omVolumeArgs = null;
            auditMap = null;
            try {
                try {
                    omVolumeArgs = OmVolumeArgs.getFromProtobuf((OzoneManagerProtocolProtos.VolumeInfo)volumeInfo);
                    omVolumeArgs.setObjectID(ozoneManager.getObjectIdFromTxId(transactionLogIndex));
                    omVolumeArgs.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
                    auditMap = omVolumeArgs.toAuditMap();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, volume, null, null);
                    }
                    acquiredVolumeLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                    acquiredUserLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                    String dbVolumeKey = omMetadataManager.getVolumeKey(volume);
                    OzoneManagerStorageProtos.PersistedUserVolumeInfo volumeList = null;
                    if (omMetadataManager.getVolumeTable().isExist((Object)dbVolumeKey)) {
                        LOG.debug("volume:{} already exists", (Object)omVolumeArgs.getVolume());
                        throw new OMException("Volume already exists", OMException.ResultCodes.VOLUME_ALREADY_EXISTS);
                    }
                    String dbUserKey = omMetadataManager.getUserKey(owner);
                    volumeList = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)omMetadataManager.getUserTable().get((Object)dbUserKey);
                    volumeList = this.addVolumeToOwnerList(volumeList, volume, owner, ozoneManager.getMaxUserVolumeCount(), transactionLogIndex);
                    this.createVolume(omMetadataManager, omVolumeArgs, volumeList, dbVolumeKey, dbUserKey, transactionLogIndex);
                    omResponse.setCreateVolumeResponse(OzoneManagerProtocolProtos.CreateVolumeResponse.newBuilder().build());
                    omClientResponse = new OMVolumeCreateResponse(omResponse.build(), omVolumeArgs, volumeList);
                    LOG.debug("volume:{} successfully created", (Object)omVolumeArgs.getVolume());
                }
                catch (IOException ex) {
                    exception = ex;
                    omClientResponse = new OMVolumeCreateResponse(this.createErrorOMResponse(omResponse, exception));
                    if (omClientResponse != null) {
                        omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                    }
                    if (acquiredUserLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                    }
                    if (acquiredVolumeLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (omClientResponse != null) {
                    omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                }
                if (acquiredUserLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                }
                if (acquiredVolumeLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                }
                throw throwable;
            }
            if (omClientResponse != null) {
                omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
            }
            if (acquiredUserLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
            }
            if (acquiredVolumeLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            }
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.CREATE_VOLUME, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.info("created volume:{} for user:{}", (Object)volume, (Object)owner);
            omMetrics.incNumVolumes();
        } else {
            LOG.error("Volume creation failed for user:{} volume:{}", new Object[]{owner, volume, exception});
            omMetrics.incNumVolumeCreateFails();
        }
        return omClientResponse;
    }

    @VisibleForTesting
    public static Logger getLogger() {
        return LOG;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMVolumeCreateRequest.java", OMVolumeCreateRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.volume.OMVolumeCreateRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 72);
    }
}

