/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.upgrade;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.upgrade.OMFinalizeUpgradeResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFinalizeUpgradeRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMFinalizeUpgradeRequest.class);

    public OMFinalizeUpgradeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        OMFinalizeUpgradeResponse response;
        block6: {
            LOG.trace("Request: {}", (Object)this.getOmRequest());
            OzoneManagerProtocolProtos.OMResponse.Builder responseBuilder = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            responseBuilder.setCmdType(OzoneManagerProtocolProtos.Type.FinalizeUpgrade);
            response = null;
            try {
                try {
                    String username = this.getOmRequest().getUserInfo().getUserName();
                    if (ozoneManager.getAclsEnabled() && !ozoneManager.isAdmin(username)) {
                        throw new OMException("Access denied for user " + username + ". " + "Superuser privilege is required to finalize upgrade.", OMException.ResultCodes.ACCESS_DENIED);
                    }
                    OzoneManagerProtocolProtos.FinalizeUpgradeRequest request = this.getOmRequest().getFinalizeUpgradeRequest();
                    String upgradeClientID = request.getUpgradeClientId();
                    UpgradeFinalizer.StatusAndMessages omStatus = ozoneManager.finalizeUpgrade(upgradeClientID);
                    HddsProtos.UpgradeFinalizationStatus.Status protoStatus = HddsProtos.UpgradeFinalizationStatus.Status.valueOf((String)omStatus.status().name());
                    HddsProtos.UpgradeFinalizationStatus responseStatus = HddsProtos.UpgradeFinalizationStatus.newBuilder().setStatus(protoStatus).build();
                    OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
                    int lV = ozoneManager.getVersionManager().getMetadataLayoutVersion();
                    omMetadataManager.getMetaTable().addCacheEntry(new CacheKey((Object)"#LAYOUTVERSION"), new CacheValue(Optional.of((Object)String.valueOf(lV)), transactionLogIndex));
                    OzoneManagerProtocolProtos.FinalizeUpgradeResponse omResponse = OzoneManagerProtocolProtos.FinalizeUpgradeResponse.newBuilder().setStatus(responseStatus).build();
                    responseBuilder.setFinalizeUpgradeResponse(omResponse);
                    response = new OMFinalizeUpgradeResponse(responseBuilder.build(), ozoneManager.getVersionManager().getMetadataLayoutVersion());
                    LOG.trace("Returning response: {}", (Object)response);
                }
                catch (IOException e) {
                    response = new OMFinalizeUpgradeResponse(this.createErrorOMResponse(responseBuilder, e), -1);
                    this.addResponseToDoubleBuffer(transactionLogIndex, response, ozoneManagerDoubleBufferHelper);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, response, ozoneManagerDoubleBufferHelper);
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, response, ozoneManagerDoubleBufferHelper);
        }
        return response;
    }
}

