/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.security;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.security.OMRenewDelegationTokenResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRenewDelegationTokenRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMRenewDelegationTokenRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMRenewDelegationTokenRequest.class);
    }

    public OMRenewDelegationTokenRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        SecurityProtos.RenewDelegationTokenRequestProto renewDelegationTokenRequest = this.getOmRequest().getRenewDelegationTokenRequest();
        long renewTime = ozoneManager.renewDelegationToken((Token<OzoneTokenIdentifier>)OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)renewDelegationTokenRequest.getToken()));
        OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto.Builder renewResponse = OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto.newBuilder();
        renewResponse.setResponse(SecurityProtos.RenewDelegationTokenResponseProto.newBuilder().setNewExpiryTime(renewTime));
        OzoneManagerProtocolProtos.OMRequest.Builder omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setUpdatedRenewDelegationTokenRequest(OzoneManagerProtocolProtos.UpdateRenewDelegationTokenRequest.newBuilder().setRenewDelegationTokenRequest(renewDelegationTokenRequest).setRenewDelegationTokenResponse(renewResponse)).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId());
        if (this.getOmRequest().hasTraceID()) {
            omRequest.setTraceID(this.getOmRequest().getTraceID());
        }
        return omRequest.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        OMRenewDelegationTokenResponse omClientResponse;
        long renewTime;
        Token ozoneTokenIdentifierToken;
        block6: {
            OzoneManagerProtocolProtos.UpdateRenewDelegationTokenRequest updateRenewDelegationTokenRequest = this.getOmRequest().getUpdatedRenewDelegationTokenRequest();
            ozoneTokenIdentifierToken = OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)updateRenewDelegationTokenRequest.getRenewDelegationTokenRequest().getToken());
            renewTime = updateRenewDelegationTokenRequest.getRenewDelegationTokenResponse().getResponse().getNewExpiryTime();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            try {
                try {
                    OzoneTokenIdentifier ozoneTokenIdentifier = OzoneTokenIdentifier.readProtoBuf((byte[])ozoneTokenIdentifierToken.getIdentifier());
                    ozoneManager.getDelegationTokenMgr().updateRenewToken((Token<OzoneTokenIdentifier>)ozoneTokenIdentifierToken, ozoneTokenIdentifier, renewTime);
                    omMetadataManager.getDelegationTokenTable().addCacheEntry(new CacheKey((Object)ozoneTokenIdentifier), new CacheValue(Optional.of((Object)renewTime), transactionLogIndex));
                    omClientResponse = new OMRenewDelegationTokenResponse(ozoneTokenIdentifier, renewTime, omResponse.setRenewDelegationTokenResponse(updateRenewDelegationTokenRequest.getRenewDelegationTokenResponse()).build());
                }
                catch (IOException ex) {
                    LOG.error("Error in Updating Renew DelegationToken {}", (Object)ozoneTokenIdentifierToken, (Object)ex);
                    omClientResponse = new OMRenewDelegationTokenResponse(null, -1L, this.createErrorOMResponse(omResponse, ex));
                    this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated renew delegation token in-memory map: {} with expiry time {}", (Object)ozoneTokenIdentifierToken, (Object)renewTime);
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMRenewDelegationTokenRequest.java", OMRenewDelegationTokenRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.security.OMRenewDelegationTokenRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 58);
    }
}

