/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.security;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.security.OMGetDelegationTokenResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMGetDelegationTokenRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMGetDelegationTokenRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMGetDelegationTokenRequest.class);
    }

    public OMGetDelegationTokenRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        SecurityProtos.GetDelegationTokenRequestProto getDelegationTokenRequest;
        Token<OzoneTokenIdentifier> token;
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.OMRequest.Builder omRequest = (token = ozoneManager.getDelegationToken(new Text((getDelegationTokenRequest = this.getOmRequest().getGetDelegationTokenRequest()).getRenewer()))) != null ? OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setUpdateGetDelegationTokenRequest(OzoneManagerProtocolProtos.UpdateGetDelegationTokenRequest.newBuilder().setGetDelegationTokenResponse(OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.newBuilder().setResponse(SecurityProtos.GetDelegationTokenResponseProto.newBuilder().setToken(OMPBHelper.convertToTokenProto(token)).build()).build()).setTokenRenewInterval(ozoneManager.getDelegationTokenMgr().getTokenRenewInterval())).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId()) : OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setUpdateGetDelegationTokenRequest(OzoneManagerProtocolProtos.UpdateGetDelegationTokenRequest.newBuilder().setGetDelegationTokenResponse(OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.newBuilder())).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId());
        if (this.getOmRequest().hasTraceID()) {
            omRequest.setTraceID(this.getOmRequest().getTraceID());
        }
        return omRequest.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        Token ozoneTokenIdentifierToken;
        OMGetDelegationTokenResponse omClientResponse;
        block7: {
            OzoneManagerProtocolProtos.UpdateGetDelegationTokenRequest updateGetDelegationTokenRequest = this.getOmRequest().getUpdateGetDelegationTokenRequest();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            if (!updateGetDelegationTokenRequest.getGetDelegationTokenResponse().hasResponse()) {
                omClientResponse = new OMGetDelegationTokenResponse(null, -1L, omResponse.setGetDelegationTokenResponse(OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.newBuilder()).build());
                omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                return omClientResponse;
            }
            SecurityProtos.TokenProto tokenProto = updateGetDelegationTokenRequest.getGetDelegationTokenResponse().getResponse().getToken();
            ozoneTokenIdentifierToken = OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)tokenProto);
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            try {
                try {
                    OzoneTokenIdentifier ozoneTokenIdentifier = OzoneTokenIdentifier.readProtoBuf((byte[])ozoneTokenIdentifierToken.getIdentifier());
                    long tokenRenewInterval = updateGetDelegationTokenRequest.getTokenRenewInterval();
                    long renewTime = ozoneManager.getDelegationTokenMgr().updateToken((Token<OzoneTokenIdentifier>)ozoneTokenIdentifierToken, ozoneTokenIdentifier, tokenRenewInterval);
                    omMetadataManager.getDelegationTokenTable().addCacheEntry(new CacheKey((Object)ozoneTokenIdentifier), new CacheValue(Optional.of((Object)renewTime), transactionLogIndex));
                    omClientResponse = new OMGetDelegationTokenResponse(ozoneTokenIdentifier, renewTime, omResponse.setGetDelegationTokenResponse(updateGetDelegationTokenRequest.getGetDelegationTokenResponse()).build());
                }
                catch (IOException ex) {
                    LOG.error("Error in Updating DelegationToken {}", (Object)ozoneTokenIdentifierToken, (Object)ex);
                    omClientResponse = new OMGetDelegationTokenResponse(null, -1L, this.createErrorOMResponse(omResponse, ex));
                    this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated delegation token in-memory map: {}", (Object)ozoneTokenIdentifierToken);
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMGetDelegationTokenRequest.java", OMGetDelegationTokenRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.security.OMGetDelegationTokenRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 59);
    }
}

