/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.security;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.security.OMGetDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.security.OMCancelDelegationTokenResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMCancelDelegationTokenRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMCancelDelegationTokenRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMGetDelegationTokenRequest.class);
    }

    public OMCancelDelegationTokenRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        ozoneManager.cancelDelegationToken(this.getToken());
        return super.preExecute(ozoneManager);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        OzoneTokenIdentifier ozoneTokenIdentifier;
        OMCancelDelegationTokenResponse omClientResponse;
        block6: {
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            ozoneTokenIdentifier = null;
            try {
                try {
                    ozoneTokenIdentifier = OzoneTokenIdentifier.readProtoBuf((byte[])this.getToken().getIdentifier());
                    ozoneManager.getDelegationTokenMgr().removeToken(ozoneTokenIdentifier);
                    omMetadataManager.getDelegationTokenTable().addCacheEntry(new CacheKey((Object)ozoneTokenIdentifier), new CacheValue(Optional.absent(), transactionLogIndex));
                    omClientResponse = new OMCancelDelegationTokenResponse(ozoneTokenIdentifier, omResponse.setCancelDelegationTokenResponse(OzoneManagerProtocolProtos.CancelDelegationTokenResponseProto.newBuilder().setResponse(SecurityProtos.CancelDelegationTokenResponseProto.newBuilder())).build());
                }
                catch (IOException ex) {
                    LOG.error("Error in cancel DelegationToken {}", (Object)ozoneTokenIdentifier, (Object)ex);
                    omClientResponse = new OMCancelDelegationTokenResponse(null, this.createErrorOMResponse(omResponse, ex));
                    this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cancelled delegation token: {}", (Object)ozoneTokenIdentifier);
        }
        return omClientResponse;
    }

    public Token<OzoneTokenIdentifier> getToken() {
        SecurityProtos.CancelDelegationTokenRequestProto cancelDelegationTokenRequest = this.getOmRequest().getCancelDelegationTokenRequest();
        return OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)cancelDelegationTokenRequest.getToken());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMCancelDelegationTokenRequest.java", OMCancelDelegationTokenRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.security.OMCancelDelegationTokenRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 57);
    }
}

