/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.security;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.security.S3RevokeSecretResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3RevokeSecretRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3RevokeSecretRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3RevokeSecretRequest.class);
    }

    public S3RevokeSecretRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.RevokeS3SecretRequest s3RevokeSecretRequest = this.getOmRequest().getRevokeS3SecretRequest();
        String kerberosID = s3RevokeSecretRequest.getKerberosID();
        UserGroupInformation ugi = ProtobufRpcEngine.Server.getRemoteUser();
        String username = ugi.getUserName();
        if (!username.equals(kerberosID) && !ozoneManager.isAdmin(ugi)) {
            throw new OMException("Requested user name '" + kerberosID + "' doesn't match current user '" + username + "', nor does current user has administrator privilege.", OMException.ResultCodes.USER_MISMATCH);
        }
        OzoneManagerProtocolProtos.RevokeS3SecretRequest revokeS3SecretRequest = OzoneManagerProtocolProtos.RevokeS3SecretRequest.newBuilder().setKerberosID(kerberosID).build();
        OzoneManagerProtocolProtos.OMRequest.Builder omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setRevokeS3SecretRequest(revokeS3SecretRequest).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId());
        if (this.getOmRequest().hasTraceID()) {
            omRequest.setTraceID(this.getOmRequest().getTraceID());
        }
        return omRequest.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        String kerberosID;
        IOException exception;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse;
        S3RevokeSecretResponse omClientResponse;
        block14: {
            omClientResponse = null;
            omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            boolean acquiredLock = false;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.RevokeS3SecretRequest revokeS3SecretRequest = this.getOmRequest().getRevokeS3SecretRequest();
            kerberosID = revokeS3SecretRequest.getKerberosID();
            try {
                try {
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, new String[]{kerberosID});
                    if (omMetadataManager.getS3SecretTable().isExist((Object)kerberosID)) {
                        omMetadataManager.getS3SecretTable().addCacheEntry(new CacheKey((Object)kerberosID), new CacheValue(Optional.absent(), transactionLogIndex));
                        omClientResponse = new S3RevokeSecretResponse(kerberosID, omResponse.setStatus(OzoneManagerProtocolProtos.Status.OK).build());
                    } else {
                        omClientResponse = new S3RevokeSecretResponse(null, omResponse.setStatus(OzoneManagerProtocolProtos.Status.S3_SECRET_NOT_FOUND).build());
                    }
                }
                catch (IOException ex) {
                    exception = ex;
                    omClientResponse = new S3RevokeSecretResponse(null, this.createErrorOMResponse(omResponse, ex));
                    this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, new String[]{kerberosID});
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, new String[]{kerberosID});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, new String[]{kerberosID});
            }
        }
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("S3RevokeSecretUser", kerberosID);
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.REVOKE_S3_SECRET, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            if (omResponse.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
                LOG.info("Secret for {} is revoked.", (Object)kerberosID);
            } else {
                LOG.info("Secret for {} doesn't exist.", (Object)kerberosID);
            }
        } else {
            LOG.error("Error when revoking secret for {}.", (Object)kerberosID, (Object)exception);
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3RevokeSecretRequest.java", S3RevokeSecretRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.security.S3RevokeSecretRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 62);
    }
}

