/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.security;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.security.S3GetSecretResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3GetSecretRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3GetSecretRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3GetSecretRequest.class);
    }

    public S3GetSecretRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.GetS3SecretRequest s3GetSecretRequest = this.getOmRequest().getGetS3SecretRequest();
        String kerberosID = s3GetSecretRequest.getKerberosID();
        UserGroupInformation ugi = ProtobufRpcEngine.Server.getRemoteUser();
        String username = ugi.getUserName();
        if (!username.equals(kerberosID) && !ozoneManager.isAdmin(ugi)) {
            throw new OMException("Requested user name '" + kerberosID + "' doesn't match current user '" + username + "', nor does current user has administrator privilege.", OMException.ResultCodes.USER_MISMATCH);
        }
        String s3Secret = DigestUtils.sha256Hex((byte[])OmUtils.getSHADigest());
        OzoneManagerProtocolProtos.UpdateGetS3SecretRequest updateGetS3SecretRequest = OzoneManagerProtocolProtos.UpdateGetS3SecretRequest.newBuilder().setAwsSecret(s3Secret).setKerberosID(kerberosID).build();
        OzoneManagerProtocolProtos.OMRequest.Builder omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setUpdateGetS3SecretRequest(updateGetS3SecretRequest).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId());
        if (this.getOmRequest().hasTraceID()) {
            omRequest.setTraceID(this.getOmRequest().getTraceID());
        }
        return omRequest.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        String kerberosID;
        IOException exception;
        S3GetSecretResponse omClientResponse;
        block12: {
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            boolean acquiredLock = false;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.UpdateGetS3SecretRequest updateGetS3SecretRequest = this.getOmRequest().getUpdateGetS3SecretRequest();
            kerberosID = updateGetS3SecretRequest.getKerberosID();
            try {
                try {
                    String awsSecret = updateGetS3SecretRequest.getAwsSecret();
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, new String[]{kerberosID});
                    S3SecretValue s3SecretValue = (S3SecretValue)omMetadataManager.getS3SecretTable().get((Object)kerberosID);
                    if (s3SecretValue == null) {
                        omMetadataManager.getS3SecretTable().addCacheEntry(new CacheKey((Object)kerberosID), new CacheValue(Optional.of((Object)new S3SecretValue(kerberosID, awsSecret)), transactionLogIndex));
                    } else {
                        awsSecret = s3SecretValue.getAwsSecret();
                    }
                    OzoneManagerProtocolProtos.GetS3SecretResponse.Builder getS3SecretResponse = OzoneManagerProtocolProtos.GetS3SecretResponse.newBuilder().setS3Secret(OzoneManagerProtocolProtos.S3Secret.newBuilder().setAwsSecret(awsSecret).setKerberosID(kerberosID));
                    omClientResponse = s3SecretValue == null ? new S3GetSecretResponse(new S3SecretValue(kerberosID, awsSecret), omResponse.setGetS3SecretResponse(getS3SecretResponse).build()) : new S3GetSecretResponse(null, omResponse.setGetS3SecretResponse(getS3SecretResponse).build());
                }
                catch (IOException ex) {
                    exception = ex;
                    omClientResponse = new S3GetSecretResponse(null, this.createErrorOMResponse(omResponse, ex));
                    this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, new String[]{kerberosID});
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, new String[]{kerberosID});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, new String[]{kerberosID});
            }
        }
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("S3GetSecretUser", kerberosID);
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.GET_S3_SECRET, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.debug("Secret for accessKey:{} is generated Successfully", (Object)kerberosID);
        } else {
            LOG.error("Secret for accessKey:{} is generation failed", (Object)kerberosID, (Object)exception);
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3GetSecretRequest.java", S3GetSecretRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.security.S3GetSecretRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 68);
    }
}

