/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCompleteResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadCompleteRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3MultipartUploadCompleteRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3MultipartUploadCompleteRequest.class);
    }

    public S3MultipartUploadCompleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.MultipartUploadCompleteRequest multipartUploadCompleteRequest = this.getOmRequest().getCompleteMultiPartUploadRequest();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartUploadCompleteRequest.getKeyArgs();
        return this.getOmRequest().toBuilder().setCompleteMultiPartUploadRequest(multipartUploadCompleteRequest.toBuilder().setKeyArgs(keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(S3MultipartUploadCompleteRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName())))).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        IOException exception;
        OMClientResponse omClientResponse;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        List partsList;
        OzoneManagerProtocolProtos.MultipartUploadCompleteRequest multipartUploadCompleteRequest;
        block12: {
            boolean acquiredLock;
            OMMetadataManager omMetadataManager;
            block11: {
                multipartUploadCompleteRequest = this.getOmRequest().getCompleteMultiPartUploadRequest();
                OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartUploadCompleteRequest.getKeyArgs();
                partsList = multipartUploadCompleteRequest.getPartsListList();
                auditMap = this.buildKeyArgsAuditMap(keyArgs);
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                String requestedVolume = volumeName;
                String requestedBucket = bucketName;
                keyName = keyArgs.getKeyName();
                String uploadID = keyArgs.getMultipartUploadID();
                String multipartKey = null;
                ozoneManager.getMetrics().incNumCompleteMultipartUploads();
                omMetadataManager = ozoneManager.getMetadataManager();
                acquiredLock = false;
                OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
                omClientResponse = null;
                exception = null;
                result = null;
                try {
                    try {
                        keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                        volumeName = keyArgs.getVolumeName();
                        bucketName = keyArgs.getBucketName();
                        multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
                        this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, OzoneObj.ResourceType.KEY);
                        acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                        this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                        String ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                        String dbOzoneKey = this.getDBOzoneKey(omMetadataManager, volumeName, bucketName, keyName);
                        String dbMultipartOpenKey = this.getDBMultipartOpenKey(volumeName, bucketName, keyName, uploadID, omMetadataManager);
                        OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
                        this.checkDirectoryAlreadyExists(ozoneManager, volumeName, bucketName, keyName, omMetadataManager);
                        if (multipartKeyInfo == null) {
                            throw new OMException(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName), OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                        }
                        TreeMap partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
                        if (partsList.size() > 0) {
                            if (partKeyInfoMap.size() == 0) {
                                LOG.error("Complete MultipartUpload failed for key {} , MPU Key has no parts in OM, parts given to upload are {}", (Object)ozoneKey, (Object)partsList);
                                throw new OMException(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName), OMException.ResultCodes.INVALID_PART);
                            }
                            ArrayList<Integer> partNumbers = new ArrayList<Integer>();
                            int partsListSize = this.getPartsListSize(requestedVolume, requestedBucket, keyName, ozoneKey, partNumbers, partsList);
                            ArrayList<OmKeyLocationInfo> partLocationInfos = new ArrayList<OmKeyLocationInfo>();
                            long dataSize = this.getMultipartDataSize(requestedVolume, requestedBucket, keyName, ozoneKey, partKeyInfoMap, partsListSize, partLocationInfos, partsList, ozoneManager);
                            OmKeyInfo omKeyInfo = this.getOmKeyInfo(ozoneManager, trxnLogIndex, keyArgs, volumeName, bucketName, keyName, dbMultipartOpenKey, omMetadataManager, dbOzoneKey, partKeyInfoMap, partLocationInfos, dataSize);
                            ArrayList<OmKeyInfo> unUsedParts = new ArrayList<OmKeyInfo>();
                            for (Map.Entry partKeyInfo : partKeyInfoMap.entrySet()) {
                                if (partNumbers.contains(partKeyInfo.getKey())) continue;
                                unUsedParts.add(OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)((OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfo.getValue()).getPartKeyInfo()));
                            }
                            this.updateCache(omMetadataManager, dbOzoneKey, dbMultipartOpenKey, multipartKey, omKeyInfo, trxnLogIndex);
                            omResponse.setCompleteMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartUploadCompleteResponse.newBuilder().setVolume(requestedVolume).setBucket(requestedBucket).setKey(keyName).setHash(DigestUtils.sha256Hex((String)keyName)));
                            omClientResponse = this.getOmClientResponse(multipartKey, omResponse, dbMultipartOpenKey, omKeyInfo, unUsedParts);
                            result = OMClientRequest.Result.SUCCESS;
                            break block11;
                        }
                        throw new OMException(String.valueOf(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName)) + " because of empty part list", OMException.ResultCodes.INVALID_REQUEST);
                    }
                    catch (IOException ex) {
                        result = OMClientRequest.Result.FAILURE;
                        exception = ex;
                        omClientResponse = this.getOmClientResponse(omResponse, exception);
                        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                        if (acquiredLock) {
                            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    throw throwable;
                }
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.logResult(ozoneManager, multipartUploadCompleteRequest, partsList, auditMap, volumeName, bucketName, keyName, exception, result);
        return omClientResponse;
    }

    protected S3MultipartUploadCompleteResponse getOmClientResponse(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, IOException exception) {
        return new S3MultipartUploadCompleteResponse(this.createErrorOMResponse(omResponse, exception));
    }

    protected OMClientResponse getOmClientResponse(String multipartKey, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, String dbMultipartOpenKey, OmKeyInfo omKeyInfo, List<OmKeyInfo> unUsedParts) {
        return new S3MultipartUploadCompleteResponse(omResponse.build(), multipartKey, dbMultipartOpenKey, omKeyInfo, unUsedParts);
    }

    protected void checkDirectoryAlreadyExists(OzoneManager ozoneManager, String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        if (ozoneManager.getEnableFileSystemPaths() && this.checkDirectoryAlreadyExists(volumeName, bucketName, keyName, omMetadataManager)) {
            throw new OMException("Can not Complete MPU for file: " + keyName + " as there is already directory in the given path", OMException.ResultCodes.NOT_A_FILE);
        }
    }

    protected void logResult(OzoneManager ozoneManager, OzoneManagerProtocolProtos.MultipartUploadCompleteRequest multipartUploadCompleteRequest, List<OzoneManagerProtocolProtos.Part> partsList, Map<String, String> auditMap, String volumeName, String bucketName, String keyName, IOException exception, OMClientRequest.Result result) {
        auditMap.put("multipartList", partsList.toString().replaceAll("\\n", " "));
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("MultipartUpload Complete request is successful for Key: {} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumCompleteMultipartUploadFails();
                LOG.error("MultipartUpload Complete request failed for Key: {} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for S3MultipartUploadCommitRequest: {}", (Object)multipartUploadCompleteRequest);
            }
        }
    }

    protected OmKeyInfo getOmKeyInfo(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerProtocolProtos.KeyArgs keyArgs, String volumeName, String bucketName, String keyName, String multipartOpenKey, OMMetadataManager omMetadataManager, String ozoneKey, TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> partKeyInfoMap, List<OmKeyLocationInfo> partLocationInfos, long dataSize) throws IOException {
        HddsProtos.ReplicationType type = partKeyInfoMap.lastEntry().getValue().getPartKeyInfo().getType();
        HddsProtos.ReplicationFactor factor = partKeyInfoMap.lastEntry().getValue().getPartKeyInfo().getFactor();
        OmKeyInfo omKeyInfo = this.getOmKeyInfoFromKeyTable(ozoneKey, keyName, omMetadataManager);
        if (omKeyInfo == null) {
            OmKeyLocationInfoGroup keyLocationInfoGroup = new OmKeyLocationInfoGroup(0L, partLocationInfos, true);
            OmKeyInfo dbOpenKeyInfo = this.getOmKeyInfoFromOpenKeyTable(multipartOpenKey, keyName, omMetadataManager);
            OmKeyInfo.Builder builder = new OmKeyInfo.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(dbOpenKeyInfo.getKeyName()).setReplicationConfig(ReplicationConfig.fromTypeAndFactor((HddsProtos.ReplicationType)type, (HddsProtos.ReplicationFactor)factor)).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(dataSize).setFileEncryptionInfo(dbOpenKeyInfo.getFileEncryptionInfo()).setOmKeyLocationInfos(Collections.singletonList(keyLocationInfoGroup)).setAcls(dbOpenKeyInfo.getAcls());
            if (dbOpenKeyInfo.getObjectID() != 0L) {
                builder.setObjectID(dbOpenKeyInfo.getObjectID());
            }
            this.updatePrefixFSOInfo(dbOpenKeyInfo, builder);
            omKeyInfo = builder.build();
        } else {
            omKeyInfo.updateLocationInfoList(partLocationInfos, true, true);
            omKeyInfo.setModificationTime(keyArgs.getModificationTime());
            omKeyInfo.setDataSize(dataSize);
        }
        omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
        return omKeyInfo;
    }

    protected void updatePrefixFSOInfo(OmKeyInfo dbOpenKeyInfo, OmKeyInfo.Builder builder) {
    }

    protected String getDBOzoneKey(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        return omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
    }

    protected String getDBMultipartOpenKey(String volumeName, String bucketName, String keyName, String uploadID, OMMetadataManager omMetadataManager) throws IOException {
        return omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
    }

    protected OmKeyInfo getOmKeyInfoFromKeyTable(String dbOzoneKey, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        return (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)dbOzoneKey);
    }

    protected OmKeyInfo getOmKeyInfoFromOpenKeyTable(String dbMultipartKey, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        return (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)dbMultipartKey);
    }

    protected void addKeyTableCacheEntry(OMMetadataManager omMetadataManager, String dbOzoneKey, OmKeyInfo omKeyInfo, long transactionLogIndex) {
        omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)dbOzoneKey), new CacheValue(Optional.of((Object)omKeyInfo), transactionLogIndex));
    }

    private int getPartsListSize(String requestedVolume, String requestedBucket, String keyName, String ozoneKey, List<Integer> partNumbers, List<OzoneManagerProtocolProtos.Part> partsList) throws OMException {
        int prevPartNumber = partsList.get(0).getPartNumber();
        int partsListSize = partsList.size();
        partNumbers.add(prevPartNumber);
        int i = 1;
        while (i < partsListSize) {
            int currentPartNumber = partsList.get(i).getPartNumber();
            if (prevPartNumber >= currentPartNumber) {
                LOG.error("PartNumber at index {} is {}, and its previous partNumber at index {} is {} for ozonekey is {}", new Object[]{i, currentPartNumber, i - 1, prevPartNumber, ozoneKey});
                throw new OMException(String.valueOf(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName)) + " because parts are in Invalid order.", OMException.ResultCodes.INVALID_PART_ORDER);
            }
            prevPartNumber = currentPartNumber;
            partNumbers.add(prevPartNumber);
            ++i;
        }
        return partsListSize;
    }

    private long getMultipartDataSize(String requestedVolume, String requestedBucket, String keyName, String ozoneKey, TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> partKeyInfoMap, int partsListSize, List<OmKeyLocationInfo> partLocationInfos, List<OzoneManagerProtocolProtos.Part> partsList, OzoneManager ozoneManager) throws OMException {
        long dataSize = 0L;
        int currentPartCount = 0;
        for (OzoneManagerProtocolProtos.Part part : partsList) {
            ++currentPartCount;
            int partNumber = part.getPartNumber();
            String partName = part.getPartName();
            OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = partKeyInfoMap.get(partNumber);
            String dbPartName = null;
            if (partKeyInfo != null) {
                dbPartName = partKeyInfo.getPartName();
            }
            if (!StringUtils.equals((CharSequence)partName, (CharSequence)dbPartName)) {
                String omPartName = partKeyInfo == null ? null : dbPartName;
                throw new OMException(String.valueOf(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName)) + ". Provided Part info is { " + partName + ", " + partNumber + "}, whereas OM has partName " + omPartName, OMException.ResultCodes.INVALID_PART);
            }
            OmKeyInfo currentPartKeyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
            if (currentPartCount != partsListSize && currentPartKeyInfo.getDataSize() < (long)ozoneManager.getMinMultipartUploadPartSize()) {
                LOG.error("MultipartUpload: {} Part number: {} size {}  is less than minimum part size {}", new Object[]{ozoneKey, partKeyInfo.getPartNumber(), currentPartKeyInfo.getDataSize(), ozoneManager.getMinMultipartUploadPartSize()});
                throw new OMException(String.valueOf(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName)) + ". Entity too small.", OMException.ResultCodes.ENTITY_TOO_SMALL);
            }
            OmKeyLocationInfoGroup currentKeyInfoGroup = (OmKeyLocationInfoGroup)currentPartKeyInfo.getKeyLocationVersions().get(0);
            currentKeyInfoGroup.getLocationList().forEach(omKeyLocationInfo -> omKeyLocationInfo.setPartNumber(partNumber));
            partLocationInfos.addAll(currentKeyInfoGroup.getLocationList());
            dataSize += currentPartKeyInfo.getDataSize();
        }
        return dataSize;
    }

    private static String failureMessage(String volume, String bucket, String keyName) {
        return "Complete Multipart Upload Failed: volume: " + volume + " bucket: " + bucket + " key: " + keyName;
    }

    private void updateCache(OMMetadataManager omMetadataManager, String dbOzoneKey, String dbMultipartOpenKey, String dbMultipartKey, OmKeyInfo omKeyInfo, long transactionLogIndex) {
        this.addKeyTableCacheEntry(omMetadataManager, dbOzoneKey, omKeyInfo, transactionLogIndex);
        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbMultipartOpenKey), new CacheValue(Optional.absent(), transactionLogIndex));
        omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)dbMultipartKey), new CacheValue(Optional.absent(), transactionLogIndex));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3MultipartUploadCompleteRequest.java", S3MultipartUploadCompleteRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCompleteRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 79);
    }
}

