/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCommitPartRequest;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCommitPartResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCommitPartResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class S3MultipartUploadCommitPartRequestWithFSO
extends S3MultipartUploadCommitPartRequest {
    public S3MultipartUploadCommitPartRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    protected String getOpenKey(String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager, long clientID) throws IOException {
        String fileName = OzoneFSUtils.getFileName((String)keyName);
        Iterator<Path> pathComponents = Paths.get(keyName, new String[0]).iterator();
        String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
        long bucketId = omBucketInfo.getObjectID();
        long parentID = OMFileRequest.getParentID(bucketId, pathComponents, keyName, omMetadataManager);
        return omMetadataManager.getOpenFileName(parentID, fileName, clientID);
    }

    @Override
    protected OmKeyInfo getOmKeyInfo(OMMetadataManager omMetadataManager, String openKey, String keyName) throws IOException {
        return OMFileRequest.getOmKeyInfoFromFileTable(true, omMetadataManager, openKey, keyName);
    }

    @Override
    protected S3MultipartUploadCommitPartResponse getOmClientResponse(OzoneManager ozoneManager, OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo, String openKey, OmKeyInfo omKeyInfo, String multipartKey, OmMultipartKeyInfo multipartKeyInfo, OzoneManagerProtocolProtos.OMResponse build, OmBucketInfo omBucketInfo) {
        return new S3MultipartUploadCommitPartResponseWithFSO(build, multipartKey, openKey, multipartKeyInfo, oldPartKeyInfo, omKeyInfo, ozoneManager.isRatisEnabled(), omBucketInfo);
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

