/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCommitPartResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadCommitPartRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3MultipartUploadCommitPartRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3MultipartUploadCommitPartRequest.class);
    }

    public S3MultipartUploadCommitPartRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest multipartCommitUploadPartRequest = this.getOmRequest().getCommitMultiPartUploadRequest();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartCommitUploadPartRequest.getKeyArgs();
        return this.getOmRequest().toBuilder().setCommitMultiPartUploadRequest(multipartCommitUploadPartRequest.toBuilder().setKeyArgs(keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(S3MultipartUploadCommitPartRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName())))).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        S3MultipartUploadCommitPartResponse omClientResponse;
        String partName;
        IOException exception;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest multipartCommitUploadPartRequest;
        block10: {
            multipartCommitUploadPartRequest = this.getOmRequest().getCommitMultiPartUploadRequest();
            keyArgs = multipartCommitUploadPartRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            ozoneManager.getMetrics().incNumCommitMultipartUploadParts();
            boolean acquiredLock = false;
            exception = null;
            partName = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo = null;
            String openKey = null;
            OmKeyInfo omKeyInfo = null;
            String multipartKey = null;
            OmMultipartKeyInfo multipartKeyInfo = null;
            result = null;
            OmBucketInfo omBucketInfo = null;
            OmBucketInfo copyBucketInfo = null;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, OzoneObj.ResourceType.KEY);
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    String uploadID = keyArgs.getMultipartUploadID();
                    multipartKey = this.getMultipartKey(volumeName, bucketName, keyName, omMetadataManager, uploadID);
                    multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
                    long clientID = multipartCommitUploadPartRequest.getClientID();
                    openKey = this.getOpenKey(volumeName, bucketName, keyName, omMetadataManager, clientID);
                    String ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    omKeyInfo = this.getOmKeyInfo(omMetadataManager, openKey, keyName);
                    if (omKeyInfo == null) {
                        throw new OMException("Failed to commit Multipart Upload key, as " + openKey + "entry is not found in the openKey table", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    omKeyInfo.setDataSize(keyArgs.getDataSize());
                    omKeyInfo.updateLocationInfoList(keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList()), true);
                    omKeyInfo.setModificationTime(keyArgs.getModificationTime());
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    int partNumber = keyArgs.getMultipartNumber();
                    partName = S3MultipartUploadCommitPartRequest.getPartName(ozoneKey, uploadID, partNumber);
                    if (multipartKeyInfo == null) {
                        throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                    }
                    oldPartKeyInfo = multipartKeyInfo.getPartKeyInfo(partNumber);
                    OzoneManagerProtocolProtos.PartKeyInfo.Builder partKeyInfo = OzoneManagerProtocolProtos.PartKeyInfo.newBuilder();
                    partKeyInfo.setPartName(partName);
                    partKeyInfo.setPartNumber(partNumber);
                    partKeyInfo.setPartKeyInfo(omKeyInfo.getProtobuf(this.getOmRequest().getVersion()));
                    multipartKeyInfo.addPartKeyInfo(partNumber, partKeyInfo.build());
                    multipartKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)multipartKeyInfo), trxnLogIndex));
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)openKey), new CacheValue(Optional.absent(), trxnLogIndex));
                    long scmBlockSize = ozoneManager.getScmBlockSize();
                    int factor = omKeyInfo.getReplicationConfig().getRequiredNodes();
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long correctedSpace = omKeyInfo.getDataSize() * (long)factor - (long)keyArgs.getKeyLocationsList().size() * scmBlockSize * (long)factor;
                    omBucketInfo.incrUsedBytes(correctedSpace);
                    omResponse.setCommitMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse.newBuilder().setPartName(partName));
                    omClientResponse = this.getOmClientResponse(ozoneManager, oldPartKeyInfo, openKey, omKeyInfo, multipartKey, multipartKeyInfo, omResponse.build(), omBucketInfo.copyObject());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.getOmClientResponse(ozoneManager, oldPartKeyInfo, openKey, omKeyInfo, multipartKey, multipartKeyInfo, this.createErrorOMResponse(omResponse, exception), copyBucketInfo);
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.logResult(ozoneManager, multipartCommitUploadPartRequest, keyArgs, auditMap, volumeName, bucketName, keyName, exception, partName, result);
        return omClientResponse;
    }

    @VisibleForTesting
    public static String getPartName(String ozoneKey, String uploadID, long partNumber) {
        return String.valueOf(ozoneKey) + "-" + uploadID + "-" + partNumber;
    }

    protected S3MultipartUploadCommitPartResponse getOmClientResponse(OzoneManager ozoneManager, OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo, String openKey, OmKeyInfo omKeyInfo, String multipartKey, OmMultipartKeyInfo multipartKeyInfo, OzoneManagerProtocolProtos.OMResponse build, OmBucketInfo omBucketInfo) {
        return new S3MultipartUploadCommitPartResponse(build, multipartKey, openKey, multipartKeyInfo, oldPartKeyInfo, omKeyInfo, ozoneManager.isRatisEnabled(), omBucketInfo);
    }

    protected OmKeyInfo getOmKeyInfo(OMMetadataManager omMetadataManager, String openKey, String keyName) throws IOException {
        return (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)openKey);
    }

    protected String getOpenKey(String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager, long clientID) throws IOException {
        return omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
    }

    private void logResult(OzoneManager ozoneManager, OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest multipartCommitUploadPartRequest, OzoneManagerProtocolProtos.KeyArgs keyArgs, Map<String, String> auditMap, String volumeName, String bucketName, String keyName, IOException exception, String partName, OMClientRequest.Result result) {
        auditMap.put("partNumber", String.valueOf(keyArgs.getMultipartNumber()));
        auditMap.put("partName", partName);
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("MultipartUpload Commit is successfully for Key:{} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumCommitMultipartUploadPartFails();
                LOG.error("MultipartUpload Commit is failed for Key:{} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for S3MultipartUploadCommitPartRequest: {}", (Object)multipartCommitUploadPartRequest);
            }
        }
    }

    private String getMultipartKey(String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager, String uploadID) {
        return omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3MultipartUploadCommitPartRequest.java", S3MultipartUploadCommitPartRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCommitPartRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 77);
    }
}

