/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadAbortRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadAbortResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class S3MultipartUploadAbortRequestWithFSO
extends S3MultipartUploadAbortRequest {
    public S3MultipartUploadAbortRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    protected OMClientResponse getOmClientResponse(IOException exception, OzoneManagerProtocolProtos.OMResponse.Builder omResponse) {
        return new S3MultipartUploadAbortResponseWithFSO(this.createErrorOMResponse(omResponse, exception));
    }

    @Override
    protected OMClientResponse getOmClientResponse(OzoneManager ozoneManager, OmMultipartKeyInfo multipartKeyInfo, String multipartKey, String multipartOpenKey, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmBucketInfo omBucketInfo) {
        S3MultipartUploadAbortResponseWithFSO omClientResp = new S3MultipartUploadAbortResponseWithFSO(omResponse.setAbortMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartUploadAbortResponse.newBuilder()).build(), multipartKey, multipartOpenKey, multipartKeyInfo, ozoneManager.isRatisEnabled(), omBucketInfo.copyObject());
        return omClientResp;
    }

    @Override
    protected String getMultipartOpenKey(String multipartUploadID, String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        String fileName = OzoneFSUtils.getFileName((String)keyName);
        Iterator<Path> pathComponents = Paths.get(keyName, new String[0]).iterator();
        String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
        long bucketId = omBucketInfo.getObjectID();
        long parentID = OMFileRequest.getParentID(bucketId, pathComponents, keyName, omMetadataManager);
        String multipartKey = omMetadataManager.getMultipartKey(parentID, fileName, multipartUploadID);
        return multipartKey;
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

