/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadAbortResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadAbortRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3MultipartUploadAbortRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3MultipartUploadAbortRequest.class);
    }

    public S3MultipartUploadAbortRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.KeyArgs keyArgs = this.getOmRequest().getAbortMultiPartUploadRequest().getKeyArgs();
        return this.getOmRequest().toBuilder().setAbortMultiPartUploadRequest(this.getOmRequest().getAbortMultiPartUploadRequest().toBuilder().setKeyArgs(keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(S3MultipartUploadAbortRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName())))).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        OMClientResponse omClientResponse;
        IOException exception;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.MultipartUploadAbortRequest multipartUploadAbortRequest;
        block16: {
            multipartUploadAbortRequest = this.getOmRequest().getAbortMultiPartUploadRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartUploadAbortRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            String requestedVolume = volumeName;
            String requestedBucket = bucketName;
            keyName = keyArgs.getKeyName();
            ozoneManager.getMetrics().incNumAbortMultipartUploads();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            exception = null;
            OmMultipartKeyInfo multipartKeyInfo = null;
            String multipartKey = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            result = null;
            OmBucketInfo omBucketInfo = null;
            try {
                try {
                    String multipartOpenKey;
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, OzoneObj.ResourceType.KEY);
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, keyArgs.getMultipartUploadID());
                    try {
                        multipartOpenKey = this.getMultipartOpenKey(keyArgs.getMultipartUploadID(), volumeName, bucketName, keyName, omMetadataManager);
                    }
                    catch (OMException ome) {
                        throw new OMException("Abort Multipart Upload Failed: volume: " + requestedVolume + ", bucket: " + requestedBucket + ", key: " + keyName, (Throwable)ome, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                    }
                    OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)multipartOpenKey);
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    if (omKeyInfo == null) {
                        throw new OMException("Abort Multipart Upload Failed: volume: " + requestedVolume + "bucket: " + requestedBucket + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                    }
                    multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
                    multipartKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    long quotaReleased = 0L;
                    int keyFactor = omKeyInfo.getReplicationConfig().getRequiredNodes();
                    for (Map.Entry entry : multipartKeyInfo.getPartKeyInfoMap().entrySet()) {
                        OzoneManagerProtocolProtos.PartKeyInfo iterPartKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)entry.getValue();
                        quotaReleased += iterPartKeyInfo.getPartKeyInfo().getDataSize() * (long)keyFactor;
                    }
                    omBucketInfo.incrUsedBytes(-quotaReleased);
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)multipartOpenKey), new CacheValue(Optional.absent(), trxnLogIndex));
                    omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.absent(), trxnLogIndex));
                    omClientResponse = this.getOmClientResponse(ozoneManager, multipartKeyInfo, multipartKey, multipartOpenKey, omResponse, omBucketInfo);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.getOmClientResponse(exception, omResponse);
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.ABORT_MULTIPART_UPLOAD, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("Abort Multipart request is successfully completed for KeyName {} in VolumeName/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumAbortMultipartUploadFails();
                LOG.error("Abort Multipart request is failed for KeyName {} in VolumeName/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for S3MultipartUploadAbortRequest: {}", (Object)multipartUploadAbortRequest);
            }
        }
        return omClientResponse;
    }

    protected OMClientResponse getOmClientResponse(IOException exception, OzoneManagerProtocolProtos.OMResponse.Builder omResponse) {
        return new S3MultipartUploadAbortResponse(this.createErrorOMResponse(omResponse, exception));
    }

    protected OMClientResponse getOmClientResponse(OzoneManager ozoneManager, OmMultipartKeyInfo multipartKeyInfo, String multipartKey, String multipartOpenKey, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmBucketInfo omBucketInfo) {
        S3MultipartUploadAbortResponse omClientResponse = new S3MultipartUploadAbortResponse(omResponse.setAbortMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartUploadAbortResponse.newBuilder()).build(), multipartKey, multipartOpenKey, multipartKeyInfo, ozoneManager.isRatisEnabled(), omBucketInfo.copyObject());
        return omClientResponse;
    }

    protected String getMultipartOpenKey(String multipartUploadID, String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        String multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, multipartUploadID);
        return multipartKey;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3MultipartUploadAbortRequest.java", S3MultipartUploadAbortRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadAbortRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 70);
    }
}

