/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3InitiateMultipartUploadResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3InitiateMultipartUploadRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3InitiateMultipartUploadRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3InitiateMultipartUploadRequest.class);
    }

    public S3InitiateMultipartUploadRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.MultipartInfoInitiateRequest multipartInfoInitiateRequest = this.getOmRequest().getInitiateMultiPartUploadRequest();
        Preconditions.checkNotNull((Object)multipartInfoInitiateRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartInfoInitiateRequest.getKeyArgs();
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setMultipartUploadID(String.valueOf(UUID.randomUUID().toString()) + "-" + UniqueId.next()).setModificationTime(Time.now()).setKeyName(S3InitiateMultipartUploadRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName()));
        this.generateRequiredEncryptionInfo(keyArgs, newKeyArgs, ozoneManager);
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).setInitiateMultiPartUploadRequest(multipartInfoInitiateRequest.toBuilder().setKeyArgs(newKeyArgs)).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        S3InitiateMultipartUploadResponse omClientResponse;
        OMClientRequest.Result result;
        IOException exception;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.MultipartInfoInitiateRequest multipartInfoInitiateRequest;
        block8: {
            multipartInfoInitiateRequest = this.getOmRequest().getInitiateMultiPartUploadRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartInfoInitiateRequest.getKeyArgs();
            Preconditions.checkNotNull((Object)keyArgs.getMultipartUploadID());
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            String requestedVolume = volumeName;
            String requestedBucket = bucketName;
            keyName = keyArgs.getKeyName();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            ozoneManager.getMetrics().incNumInitiateMultipartUploads();
            boolean acquiredBucketLock = false;
            exception = null;
            OmMultipartKeyInfo multipartKeyInfo = null;
            OmKeyInfo omKeyInfo = null;
            result = null;
            long objectID = ozoneManager.getObjectIdFromTxId(transactionLogIndex);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    acquiredBucketLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    String multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, keyArgs.getMultipartUploadID());
                    ReplicationConfig replicationConfig = ReplicationConfig.fromTypeAndFactor((HddsProtos.ReplicationType)keyArgs.getType(), (HddsProtos.ReplicationFactor)keyArgs.getFactor());
                    multipartKeyInfo = new OmMultipartKeyInfo.Builder().setUploadID(keyArgs.getMultipartUploadID()).setCreationTime(keyArgs.getModificationTime()).setReplicationConfig(replicationConfig).setObjectID(objectID).setUpdateID(transactionLogIndex).build();
                    OmBucketInfo bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
                    omKeyInfo = new OmKeyInfo.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyArgs.getKeyName()).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setReplicationConfig(replicationConfig).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setAcls(this.getAclsForKey(keyArgs, bucketInfo, ozoneManager.getPrefixManager())).setObjectID(objectID).setUpdateID(transactionLogIndex).setFileEncryptionInfo(keyArgs.hasFileEncryptionInfo() ? OMPBHelper.convert((OzoneManagerProtocolProtos.FileEncryptionInfoProto)keyArgs.getFileEncryptionInfo()) : null).build();
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)omKeyInfo), transactionLogIndex));
                    omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)multipartKeyInfo), transactionLogIndex));
                    omClientResponse = new S3InitiateMultipartUploadResponse(omResponse.setInitiateMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartInfoInitiateResponse.newBuilder().setVolumeName(requestedVolume).setBucketName(requestedBucket).setKeyName(keyName).setMultipartUploadID(keyArgs.getMultipartUploadID())).build(), multipartKeyInfo, omKeyInfo);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new S3InitiateMultipartUploadResponse(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                    if (acquiredBucketLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredBucketLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.logResult(ozoneManager, multipartInfoInitiateRequest, auditMap, volumeName, bucketName, keyName, exception, result);
        return omClientResponse;
    }

    protected void logResult(OzoneManager ozoneManager, OzoneManagerProtocolProtos.MultipartInfoInitiateRequest multipartInfoInitiateRequest, Map<String, String> auditMap, String volumeName, String bucketName, String keyName, IOException exception, OMClientRequest.Result result) {
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("S3 InitiateMultipart Upload request for Key {} in Volume/Bucket {}/{} is successfully completed", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumInitiateMultipartUploadFails();
                LOG.error("S3 InitiateMultipart Upload request for Key {} in Volume/Bucket {}/{} is failed", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for S3InitiateMultipartUploadRequest: {}", (Object)multipartInfoInitiateRequest);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3InitiateMultipartUploadRequest.java", S3InitiateMultipartUploadRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.multipart.S3InitiateMultipartUploadRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 73);
    }
}

