/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl.prefix;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManagerImpl;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.ObjectParser;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public abstract class OMPrefixAclRequest
extends OMClientRequest {
    public OMPrefixAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        boolean opResult;
        IOException exception;
        OMClientResponse omClientResponse;
        block13: {
            OmPrefixInfo omPrefixInfo = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            String volume = null;
            String bucket = null;
            String key = null;
            PrefixManagerImpl.OMPrefixAclOpResult operationResult = null;
            opResult = false;
            result = null;
            PrefixManagerImpl prefixManager = (PrefixManagerImpl)ozoneManager.getPrefixManager();
            try {
                try {
                    String prefixPath = this.getOzoneObj().getPath();
                    ObjectParser objectParser = new ObjectParser(prefixPath, OzoneManagerProtocolProtos.OzoneObj.ObjectType.PREFIX);
                    volume = objectParser.getVolume();
                    bucket = objectParser.getBucket();
                    key = objectParser.getKey();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.PREFIX, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, bucket, key);
                    }
                    lockAcquired = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                    omPrefixInfo = (OmPrefixInfo)omMetadataManager.getPrefixTable().get((Object)prefixPath);
                    try {
                        operationResult = this.apply(prefixManager, omPrefixInfo, trxnLogIndex);
                    }
                    catch (IOException iOException) {
                        operationResult = new PrefixManagerImpl.OMPrefixAclOpResult(null, false);
                    }
                    omPrefixInfo = operationResult.getOmPrefixInfo();
                    omPrefixInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    if (this.getOmRequest().hasRemoveAclRequest() && omPrefixInfo.getAcls().size() == 0) {
                        omMetadataManager.getPrefixTable().addCacheEntry(new CacheKey((Object)prefixPath), new CacheValue(Optional.absent(), trxnLogIndex));
                    } else {
                        omMetadataManager.getPrefixTable().addCacheEntry(new CacheKey((Object)prefixPath), new CacheValue(Optional.of((Object)omPrefixInfo), trxnLogIndex));
                    }
                    opResult = operationResult.isSuccess();
                    omClientResponse = this.onSuccess(omResponse, omPrefixInfo, opResult);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, ex);
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (lockAcquired) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{this.getOzoneObj().getPath()});
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (lockAcquired) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{this.getOzoneObj().getPath()});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (lockAcquired) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{this.getOzoneObj().getPath()});
            }
        }
        OzoneObj obj = this.getOzoneObj();
        Map auditMap = obj.toAuditMap();
        this.onComplete(opResult, exception, ozoneManager.getMetrics(), result, trxnLogIndex, ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    abstract OzoneObj getOzoneObj();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmPrefixInfo var2, boolean var3);

    abstract OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder var1, IOException var2);

    abstract void onComplete(boolean var1, IOException var2, OMMetrics var3, OMClientRequest.Result var4, long var5, AuditLogger var7, Map<String, String> var8);

    abstract PrefixManagerImpl.OMPrefixAclOpResult apply(PrefixManagerImpl var1, OmPrefixInfo var2, long var3) throws IOException;
}

