/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAclRequest;
import org.apache.hadoop.ozone.om.request.util.ObjectParser;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public abstract class OMKeyAclRequestWithFSO
extends OMKeyAclRequest {
    public OMKeyAclRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omReq) {
        super(omReq);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        boolean operationResult;
        IOException exception;
        OMClientResponse omClientResponse;
        block17: {
            OmKeyInfo omKeyInfo = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            String volume = null;
            String bucket = null;
            String key = null;
            operationResult = false;
            result = null;
            try {
                try {
                    ObjectParser objectParser = new ObjectParser(this.getPath(), OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY);
                    volume = objectParser.getVolume();
                    bucket = objectParser.getBucket();
                    key = objectParser.getKey();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, bucket, key);
                    }
                    lockAcquired = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                    OzoneFileStatus keyStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volume, bucket, key, 0L);
                    if (keyStatus == null) {
                        throw new OMException("Key not found. Key:" + key, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    omKeyInfo = keyStatus.getKeyInfo();
                    String dbKey = omKeyInfo.getPath();
                    boolean isDirectory = keyStatus.isDirectory();
                    operationResult = this.apply(omKeyInfo, trxnLogIndex);
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    long modificationTime = omKeyInfo.getModificationTime();
                    if (this.getOmRequest().getAddAclRequest().hasObj() && operationResult) {
                        modificationTime = this.getOmRequest().getAddAclRequest().getModificationTime();
                    } else if (this.getOmRequest().getSetAclRequest().hasObj()) {
                        modificationTime = this.getOmRequest().getSetAclRequest().getModificationTime();
                    } else if (this.getOmRequest().getRemoveAclRequest().hasObj() && operationResult) {
                        modificationTime = this.getOmRequest().getRemoveAclRequest().getModificationTime();
                    }
                    omKeyInfo.setModificationTime(modificationTime);
                    if (isDirectory) {
                        Table dirTable = omMetadataManager.getDirectoryTable();
                        dirTable.addCacheEntry(new CacheKey((Object)dbKey), new CacheValue(Optional.of((Object)OMFileRequest.getDirectoryInfo(omKeyInfo)), trxnLogIndex));
                    } else {
                        omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)dbKey), new CacheValue(Optional.of((Object)omKeyInfo), trxnLogIndex));
                    }
                    omClientResponse = this.onSuccess(omResponse, omKeyInfo, operationResult, isDirectory);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, ex);
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (lockAcquired) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (lockAcquired) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (lockAcquired) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
            }
        }
        OzoneObj obj = this.getObject();
        Map auditMap = obj.toAuditMap();
        this.onComplete(result, operationResult, exception, trxnLogIndex, ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    @Override
    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResp, IOException exception) {
        return new OMKeyAclResponseWithFSO(this.createErrorOMResponse(omResp, exception));
    }

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmKeyInfo var2, boolean var3, boolean var4);
}

