/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMTrashRecoverResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMTrashRecoverRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMTrashRecoverRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMTrashRecoverRequest.class);
    }

    public OMTrashRecoverRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.RecoverTrashRequest recoverTrashRequest = this.getOmRequest().getRecoverTrashRequest();
        Preconditions.checkNotNull((Object)recoverTrashRequest);
        return this.getOmRequest().toBuilder().build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        OMClientResponse omClientResponse;
        block11: {
            OzoneManagerProtocolProtos.RecoverTrashRequest recoverTrashRequest = this.getOmRequest().getRecoverTrashRequest();
            Preconditions.checkNotNull((Object)recoverTrashRequest);
            String volumeName = recoverTrashRequest.getVolumeName();
            String bucketName = recoverTrashRequest.getBucketName();
            String keyName = recoverTrashRequest.getKeyName();
            String destinationBucket = recoverTrashRequest.getDestinationBucket();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.RecoverTrash).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquireLock = false;
            omClientResponse = null;
            try {
                try {
                    ResolvedBucket bucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)destinationBucket), (OMClientRequest)this);
                    volumeName = bucket.realVolume();
                    destinationBucket = bucket.realBucket();
                    this.checkBucketAcls(ozoneManager, volumeName, destinationBucket, keyName, IAccessAuthorizer.ACLType.WRITE);
                    acquireLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, destinationBucket});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    this.validateBucketAndVolume(omMetadataManager, volumeName, destinationBucket);
                    omClientResponse = null;
                }
                catch (IOException ex) {
                    LOG.error("Fail for recovering trash.", (Throwable)ex);
                    omClientResponse = new OMTrashRecoverResponse(null, this.createErrorOMResponse(omResponse, ex));
                    if (omClientResponse != null) {
                        omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                    }
                    if (acquireLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, destinationBucket});
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (omClientResponse != null) {
                    omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                }
                if (acquireLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, destinationBucket});
                }
                throw throwable;
            }
            if (omClientResponse != null) {
                omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
            }
            if (acquireLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, destinationBucket});
            }
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMTrashRecoverRequest.java", OMTrashRecoverRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMTrashRecoverRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 58);
    }
}

