/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.util.List;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMPathsPurgeResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OMPathsPurgeRequestWithFSO
extends OMKeyRequest {
    public OMPathsPurgeRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OzoneManagerProtocolProtos.PurgePathsRequest purgePathsRequest = this.getOmRequest().getPurgePathsRequest();
        List deletedDirsList = purgePathsRequest.getDeletedDirsList();
        List deletedSubFilesList = purgePathsRequest.getDeletedSubFilesList();
        List markDeletedSubDirsList = purgePathsRequest.getMarkDeletedSubDirsList();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        OMPathsPurgeResponseWithFSO omClientResponse = new OMPathsPurgeResponseWithFSO(omResponse.build(), markDeletedSubDirsList, deletedSubFilesList, deletedDirsList, ozoneManager.isRatisEnabled());
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        return omClientResponse;
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

