/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmRenameKeys;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeysRenameResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeysRenameRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeysRenameRequest.class);

    public OMKeysRenameRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        Map<String, String> auditMap;
        OMClientRequest.Result result;
        IOException exception;
        AuditLogger auditLogger;
        HashMap<String, String> renamedKeys;
        ArrayList<OzoneManagerProtocolProtos.RenameKeysMap> unRenamedKeys;
        OMKeysRenameResponse omClientResponse;
        OzoneManagerProtocolProtos.RenameKeysRequest renameKeysRequest;
        block18: {
            renameKeysRequest = this.getOmRequest().getRenameKeysRequest();
            OzoneManagerProtocolProtos.RenameKeysArgs renameKeysArgs = renameKeysRequest.getRenameKeysArgs();
            String volumeName = renameKeysArgs.getVolumeName();
            String bucketName = renameKeysArgs.getBucketName();
            omClientResponse = null;
            unRenamedKeys = new ArrayList<OzoneManagerProtocolProtos.RenameKeysMap>();
            renamedKeys = new HashMap<String, String>();
            HashMap<String, OmKeyInfo> fromKeyAndToKeyInfo = new HashMap<String, OmKeyInfo>();
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyRenames();
            auditLogger = ozoneManager.getAuditLogger();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            exception = null;
            OmKeyInfo fromKeyValue = null;
            result = null;
            auditMap = new LinkedHashMap<String, String>();
            String fromKeyName = null;
            String toKeyName = null;
            boolean acquiredLock = false;
            boolean renameStatus = true;
            try {
                try {
                    ResolvedBucket bucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName), (OMClientRequest)this);
                    bucket.audit(auditMap);
                    volumeName = bucket.realVolume();
                    bucketName = bucket.realBucket();
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    String volumeOwner = this.getVolumeOwner(omMetadataManager, volumeName);
                    for (OzoneManagerProtocolProtos.RenameKeysMap renameKey : renameKeysArgs.getRenameKeysMapList()) {
                        fromKeyName = renameKey.getFromKeyName();
                        toKeyName = renameKey.getToKeyName();
                        OzoneManagerProtocolProtos.RenameKeysMap.Builder unRenameKey = OzoneManagerProtocolProtos.RenameKeysMap.newBuilder();
                        if (toKeyName.length() == 0 || fromKeyName.length() == 0) {
                            renameStatus = false;
                            unRenamedKeys.add(unRenameKey.setFromKeyName(fromKeyName).setToKeyName(toKeyName).build());
                            LOG.error("Key name is empty fromKeyName {} toKeyName {}", (Object)fromKeyName, (Object)toKeyName);
                            continue;
                        }
                        try {
                            this.checkKeyAcls(ozoneManager, volumeName, bucketName, fromKeyName, IAccessAuthorizer.ACLType.DELETE, OzoneObj.ResourceType.KEY, volumeOwner);
                            this.checkKeyAcls(ozoneManager, volumeName, bucketName, toKeyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY, volumeOwner);
                        }
                        catch (Exception ex) {
                            renameStatus = false;
                            unRenamedKeys.add(unRenameKey.setFromKeyName(fromKeyName).setToKeyName(toKeyName).build());
                            LOG.error("Acl check failed for fromKeyName {} toKeyName {}", new Object[]{fromKeyName, toKeyName, ex});
                            continue;
                        }
                        String fromKey = omMetadataManager.getOzoneKey(volumeName, bucketName, fromKeyName);
                        String toKey = omMetadataManager.getOzoneKey(volumeName, bucketName, toKeyName);
                        OmKeyInfo toKeyValue = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)toKey);
                        if (toKeyValue != null) {
                            renameStatus = false;
                            unRenamedKeys.add(unRenameKey.setFromKeyName(fromKeyName).setToKeyName(toKeyName).build());
                            LOG.error("Received a request name of new key {} already exists", (Object)toKeyName);
                        }
                        if ((fromKeyValue = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)fromKey)) == null) {
                            renameStatus = false;
                            unRenamedKeys.add(unRenameKey.setFromKeyName(fromKeyName).setToKeyName(toKeyName).build());
                            LOG.error("Received a request to rename a Key does not exist {}", (Object)fromKey);
                            continue;
                        }
                        fromKeyValue.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                        fromKeyValue.setKeyName(toKeyName);
                        fromKeyValue.setModificationTime(Time.now());
                        Table keyTable = omMetadataManager.getKeyTable();
                        keyTable.addCacheEntry(new CacheKey((Object)fromKey), new CacheValue(Optional.absent(), trxnLogIndex));
                        keyTable.addCacheEntry(new CacheKey((Object)toKey), new CacheValue(Optional.of((Object)fromKeyValue), trxnLogIndex));
                        renamedKeys.put(fromKeyName, toKeyName);
                        fromKeyAndToKeyInfo.put(fromKeyName, fromKeyValue);
                    }
                    OmRenameKeys newOmRenameKeys = new OmRenameKeys(volumeName, bucketName, null, fromKeyAndToKeyInfo);
                    omClientResponse = new OMKeysRenameResponse(omResponse.setRenameKeysResponse(OzoneManagerProtocolProtos.RenameKeysResponse.newBuilder().setStatus(renameStatus).addAllUnRenamedKeys(unRenamedKeys)).setStatus(renameStatus ? OzoneManagerProtocolProtos.Status.OK : OzoneManagerProtocolProtos.Status.PARTIAL_RENAME).setSuccess(renameStatus).build(), newOmRenameKeys);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    this.createErrorOMResponse(omResponse, ex);
                    omResponse.setRenameKeysResponse(OzoneManagerProtocolProtos.RenameKeysResponse.newBuilder().setStatus(renameStatus).addAllUnRenamedKeys(unRenamedKeys).build());
                    omClientResponse = new OMKeysRenameResponse(omResponse.build());
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        auditMap = this.buildAuditMap(auditMap, renamedKeys, unRenamedKeys);
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.RENAME_KEYS, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("Rename Keys is successfully completed for auditMap:{}.", auditMap);
                break;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumKeyRenameFails();
                LOG.error("Rename keys failed for auditMap:{}.", auditMap);
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeysRenameRequest: {}", (Object)renameKeysRequest);
            }
        }
        return omClientResponse;
    }

    private Map<String, String> buildAuditMap(Map<String, String> auditMap, Map<String, String> renamedKeys, List<OzoneManagerProtocolProtos.RenameKeysMap> unRenameKeys) {
        HashMap<String, String> unRenameKeysMap = new HashMap<String, String>();
        for (OzoneManagerProtocolProtos.RenameKeysMap renameKeysMap : unRenameKeys) {
            unRenameKeysMap.put(renameKeysMap.getFromKeyName(), renameKeysMap.getToKeyName());
        }
        auditMap.put("renamedKeysMap", renamedKeys.toString());
        auditMap.put("unRenamedKeysMap", ((Object)unRenameKeysMap).toString());
        return auditMap;
    }
}

