/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeysDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeysDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeysDeleteRequest.class);
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result;

    public OMKeysDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        block19: {
            block17: {
                block18: {
                    deleteKeyRequest = this.getOmRequest().getDeleteKeysRequest();
                    deleteKeyArgs = deleteKeyRequest.getDeleteKeys();
                    deleteKeys = new ArrayList<String>(deleteKeyArgs.getKeysList());
                    exception = null;
                    omClientResponse = null;
                    result = null;
                    omMetrics = ozoneManager.getMetrics();
                    omMetrics.incNumKeyDeletes();
                    volumeName = deleteKeyArgs.getVolumeName();
                    bucketName = deleteKeyArgs.getBucketName();
                    auditMap = new LinkedHashMap<String, String>();
                    auditMap.put("volume", volumeName);
                    auditMap.put("bucket", bucketName);
                    omKeyInfoList = new ArrayList<OmKeyInfo>();
                    auditLogger = ozoneManager.getAuditLogger();
                    userInfo = this.getOmRequest().getUserInfo();
                    omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
                    omMetadataManager = ozoneManager.getMetadataManager();
                    acquiredLock = false;
                    indexFailed = 0;
                    length = deleteKeys.size();
                    unDeletedKeys = OzoneManagerProtocolProtos.DeleteKeyArgs.newBuilder().setVolumeName(volumeName).setBucketName(bucketName);
                    deleteStatus = true;
                    try {
                        try {
                            bucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName), (OMClientRequest)this);
                            bucket.audit(auditMap);
                            volumeName = bucket.realVolume();
                            bucketName = bucket.realBucket();
                            acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                            volumeOwner = this.getVolumeOwner(omMetadataManager, volumeName);
                            indexFailed = 0;
                            while (indexFailed < length) {
                                keyName = deleteKeyArgs.getKeys(indexFailed);
                                objectKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                                omKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)objectKey);
                                if (omKeyInfo == null) {
                                    deleteStatus = false;
                                    OMKeysDeleteRequest.LOG.error("Received a request to delete a Key does not exist {}", (Object)objectKey);
                                    deleteKeys.remove(keyName);
                                    unDeletedKeys.addKeys(keyName);
                                } else {
                                    try {
                                        this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.DELETE, OzoneObj.ResourceType.KEY, volumeOwner);
                                        omKeyInfoList.add(omKeyInfo);
                                    }
                                    catch (Exception ex) {
                                        deleteStatus = false;
                                        OMKeysDeleteRequest.LOG.error("Acl check failed for Key: {}", (Object)objectKey, (Object)ex);
                                        deleteKeys.remove(keyName);
                                        unDeletedKeys.addKeys(keyName);
                                    }
                                }
                                ++indexFailed;
                            }
                            quotaReleased = 0L;
                            omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                            for (OmKeyInfo omKeyInfo : omKeyInfoList) {
                                omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, omKeyInfo.getKeyName())), new CacheValue(Optional.absent(), trxnLogIndex));
                                omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                                quotaReleased += OMKeysDeleteRequest.sumBlockLengths(omKeyInfo);
                            }
                            omBucketInfo.incrUsedBytes(-quotaReleased);
                            omBucketInfo.incrUsedNamespace(-1L * (long)omKeyInfoList.size());
                            omClientResponse = new OMKeysDeleteResponse(omResponse.setDeleteKeysResponse(OzoneManagerProtocolProtos.DeleteKeysResponse.newBuilder().setStatus(deleteStatus).setUnDeletedKeys(unDeletedKeys)).setStatus(deleteStatus != false ? OzoneManagerProtocolProtos.Status.OK : OzoneManagerProtocolProtos.Status.PARTIAL_DELETE).setSuccess(deleteStatus).build(), omKeyInfoList, ozoneManager.isRatisEnabled(), omBucketInfo.copyObject());
                            result = OMClientRequest.Result.SUCCESS;
                            break block17;
                        }
                        catch (IOException ex) {
                            result = OMClientRequest.Result.FAILURE;
                            exception = ex;
                            this.createErrorOMResponse(omResponse, ex);
                            deleteKeys = new ArrayList<E>();
                            i = indexFailed;
                            ** while (i < length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            unDeletedKeys.addKeys(deleteKeyArgs.getKeys(i));
                            ++i;
                            continue;
                        }
lbl87:
                        // 1 sources

                        omResponse.setDeleteKeysResponse(OzoneManagerProtocolProtos.DeleteKeysResponse.newBuilder().setStatus(false).setUnDeletedKeys(unDeletedKeys).build()).build();
                        omClientResponse = new OMKeysDeleteResponse(omResponse.build());
                        if (!acquiredLock) break block18;
                    }
                    catch (Throwable var32_35) {
                        if (acquiredLock) {
                            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                        }
                        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                        throw var32_35;
                    }
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                break block19;
            }
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        }
        OMKeysDeleteRequest.addDeletedKeys(auditMap, deleteKeys, unDeletedKeys.getKeysList());
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_KEYS, auditMap, exception, userInfo));
        switch (OMKeysDeleteRequest.$SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result()[result.ordinal()]) {
            case 1: {
                omMetrics.decNumKeys(deleteKeys.size());
                if (!OMKeysDeleteRequest.LOG.isDebugEnabled()) break;
                OMKeysDeleteRequest.LOG.debug("Keys delete success. Volume:{}, Bucket:{}, Keys:{}", new Object[]{volumeName, bucketName, auditMap.get("deletedKeysList")});
                break;
            }
            case 2: {
                omMetrics.incNumKeyDeleteFails();
                if (!OMKeysDeleteRequest.LOG.isDebugEnabled()) break;
                OMKeysDeleteRequest.LOG.debug("Keys delete failed. Volume:{}, Bucket:{}, DeletedKeys:{}, UnDeletedKeys:{}", new Object[]{volumeName, bucketName, auditMap.get("deletedKeysList"), auditMap.get("unDeletedKeysList"), exception});
                break;
            }
            default: {
                OMKeysDeleteRequest.LOG.error("Unrecognized Result for OMKeysDeleteRequest: {}", (Object)deleteKeyRequest);
            }
        }
        return omClientResponse;
    }

    private static void addDeletedKeys(Map<String, String> auditMap, List<String> deletedKeys, List<String> unDeletedKeys) {
        auditMap.put("deletedKeysList", String.join((CharSequence)",", deletedKeys));
        auditMap.put("unDeletedKeysList", String.join((CharSequence)",", unDeletedKeys));
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result() {
        if ($SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result != null) {
            return $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result;
        }
        int[] nArray = new int[OMClientRequest.Result.values().length];
        try {
            nArray[OMClientRequest.Result.FAILURE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OMClientRequest.Result.SUCCESS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result = nArray;
        return nArray;
    }
}

