/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRenameRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyRenameResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyRenameRequestWithFSO
extends OMKeyRenameRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyRenameRequestWithFSO.class);

    public OMKeyRenameRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        void var17_21;
        OMClientRequest.Result result;
        IOException exception;
        AuditLogger auditLogger;
        String toKeyName;
        String fromKeyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.RenameKeyRequest renameKeyRequest;
        block18: {
            void var17_20;
            renameKeyRequest = this.getOmRequest().getRenameKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = renameKeyRequest.getKeyArgs();
            auditMap = this.buildAuditMap(keyArgs, renameKeyRequest);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            fromKeyName = keyArgs.getKeyName();
            toKeyName = renameKeyRequest.getToKeyName();
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyRenames();
            auditLogger = ozoneManager.getAuditLogger();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            OMClientResponse oMClientResponse = null;
            exception = null;
            try {
                try {
                    if (toKeyName.length() == 0 || fromKeyName.length() == 0) {
                        throw new OMException("Key name is empty", OMException.ResultCodes.INVALID_KEY_NAME);
                    }
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkACLs(ozoneManager, volumeName, bucketName, fromKeyName, IAccessAuthorizer.ACLType.DELETE);
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, toKeyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    OzoneFileStatus fromKeyFileStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, fromKeyName, 0L);
                    if (fromKeyFileStatus == null) {
                        throw new OMException("Key not found " + fromKeyName, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    OmKeyInfo fromKeyValue = fromKeyFileStatus.getKeyInfo();
                    boolean isRenameDirectory = fromKeyFileStatus.isDirectory();
                    OMFileRequest.verifyToDirIsASubDirOfFromDirectory(fromKeyName, toKeyName, fromKeyFileStatus.isDirectory());
                    OzoneFileStatus toKeyFileStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, toKeyName, 0L);
                    if (toKeyFileStatus != null) {
                        OmKeyInfo toKeyValue = toKeyFileStatus.getKeyInfo();
                        if (fromKeyValue.getKeyName().equals(toKeyValue.getKeyName())) {
                            if (!toKeyFileStatus.isFile()) throw new OMException("Key already exists " + toKeyName, OMException.ResultCodes.KEY_ALREADY_EXISTS);
                            result = OMClientRequest.Result.SUCCESS;
                        } else {
                            if (!toKeyFileStatus.isDirectory()) throw new OMException("Failed to rename, key already exists " + toKeyName, OMException.ResultCodes.KEY_ALREADY_EXISTS);
                            String fromFileName = OzoneFSUtils.getFileName((String)fromKeyName);
                            String newToKeyName = OzoneFSUtils.appendFileNameToKeyPath((String)toKeyName, (String)fromFileName);
                            OzoneFileStatus newToOzoneFileStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, newToKeyName, 0L);
                            if (newToOzoneFileStatus != null) {
                                throw new OMException(String.format("Failed to rename %s to %s, file already exists or not empty!", fromKeyName, newToKeyName), OMException.ResultCodes.KEY_ALREADY_EXISTS);
                            }
                            OMClientResponse oMClientResponse2 = this.renameKey(toKeyValue.getObjectID(), trxnLogIndex, fromKeyValue, isRenameDirectory, newToKeyName, keyArgs.getModificationTime(), omResponse, ozoneManager);
                            result = OMClientRequest.Result.SUCCESS;
                        }
                    } else {
                        long toKeyParentId = OMFileRequest.getToKeyNameParentId(volumeName, bucketName, toKeyName, fromKeyName, omMetadataManager);
                        OMClientResponse oMClientResponse3 = this.renameKey(toKeyParentId, trxnLogIndex, fromKeyValue, isRenameDirectory, toKeyName, keyArgs.getModificationTime(), omResponse, ozoneManager);
                        result = OMClientRequest.Result.SUCCESS;
                    }
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    OMKeyRenameResponseWithFSO oMKeyRenameResponseWithFSO = new OMKeyRenameResponseWithFSO(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(trxnLogIndex, oMKeyRenameResponseWithFSO, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, oMClientResponse, omDoubleBufferHelper);
                if (!acquiredLock) throw throwable;
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, (OMClientResponse)var17_20, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.RENAME_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("Rename Key is successfully completed for volume:{} bucket:{} fromKey:{} toKey:{}. ", new Object[]{volumeName, bucketName, fromKeyName, toKeyName});
                return var17_21;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumKeyRenameFails();
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Key: {} not found.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, fromKeyName});
                return var17_21;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyRenameRequest: {}", (Object)renameKeyRequest);
            }
        }
        return var17_21;
    }

    private OMClientResponse renameKey(long toKeyParentId, long trxnLogIndex, OmKeyInfo fromKeyValue, boolean isRenameDirectory, String toKeyName, long modificationTime, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OzoneManager ozoneManager) {
        String dbFromKey = fromKeyValue.getPath();
        String toKeyFileName = OzoneFSUtils.getFileName((String)toKeyName);
        fromKeyValue.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
        fromKeyValue.setKeyName(toKeyFileName);
        fromKeyValue.setFileName(toKeyFileName);
        fromKeyValue.setParentObjectID(toKeyParentId);
        fromKeyValue.setModificationTime(modificationTime);
        String dbToKey = fromKeyValue.getPath();
        OMMetadataManager metadataMgr = ozoneManager.getMetadataManager();
        if (isRenameDirectory) {
            Table dirTable = metadataMgr.getDirectoryTable();
            dirTable.addCacheEntry(new CacheKey((Object)dbFromKey), new CacheValue(Optional.absent(), trxnLogIndex));
            dirTable.addCacheEntry(new CacheKey((Object)dbToKey), new CacheValue(Optional.of((Object)OMFileRequest.getDirectoryInfo(fromKeyValue)), trxnLogIndex));
        } else {
            Table keyTable = metadataMgr.getKeyTable();
            keyTable.addCacheEntry(new CacheKey((Object)dbFromKey), new CacheValue(Optional.absent(), trxnLogIndex));
            keyTable.addCacheEntry(new CacheKey((Object)dbToKey), new CacheValue(Optional.of((Object)fromKeyValue), trxnLogIndex));
        }
        OMKeyRenameResponseWithFSO omClientResponse = new OMKeyRenameResponseWithFSO(omResponse.setRenameKeyResponse(OzoneManagerProtocolProtos.RenameKeyResponse.newBuilder()).build(), dbFromKey, dbToKey, fromKeyValue, isRenameDirectory);
        return omClientResponse;
    }

    private Map<String, String> buildAuditMap(OzoneManagerProtocolProtos.KeyArgs keyArgs, OzoneManagerProtocolProtos.RenameKeyRequest renameKeyRequest) {
        Map<String, String> auditMap = this.buildKeyArgsAuditMap(keyArgs);
        auditMap.remove("key");
        auditMap.put("srcKey", keyArgs.getKeyName());
        auditMap.put("dstKey", renameKeyRequest.getToKeyName());
        return auditMap;
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

