/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyRenameResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyRenameRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMKeyRenameRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMKeyRenameRequest.class);
    }

    public OMKeyRenameRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.RenameKeyRequest renameKeyRequest = this.getOmRequest().getRenameKeyRequest();
        Preconditions.checkNotNull((Object)renameKeyRequest);
        boolean checkKeyNameEnabled = ozoneManager.getConfiguration().getBoolean("ozone.om.keyname.character.check.enabled", false);
        if (checkKeyNameEnabled) {
            OmUtils.validateKeyName((String)renameKeyRequest.getToKeyName());
        }
        OzoneManagerProtocolProtos.KeyArgs renameKeyArgs = renameKeyRequest.getKeyArgs();
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = renameKeyArgs.toBuilder().setModificationTime(Time.now());
        return this.getOmRequest().toBuilder().setRenameKeyRequest(renameKeyRequest.toBuilder().setKeyArgs(newKeyArgs)).setUserInfo(this.getUserIfNotExists(ozoneManager)).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        IOException exception;
        OMKeyRenameResponse omClientResponse;
        AuditLogger auditLogger;
        String toKeyName;
        String fromKeyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.RenameKeyRequest renameKeyRequest;
        block15: {
            renameKeyRequest = this.getOmRequest().getRenameKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = renameKeyRequest.getKeyArgs();
            auditMap = this.buildAuditMap(keyArgs, renameKeyRequest);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            fromKeyName = keyArgs.getKeyName();
            toKeyName = renameKeyRequest.getToKeyName();
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyRenames();
            auditLogger = ozoneManager.getAuditLogger();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            omClientResponse = null;
            exception = null;
            OmKeyInfo fromKeyValue = null;
            String toKey = null;
            String fromKey = null;
            result = null;
            try {
                try {
                    if (toKeyName.length() == 0 || fromKeyName.length() == 0) {
                        throw new OMException("Key name is empty", OMException.ResultCodes.INVALID_KEY_NAME);
                    }
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, fromKeyName, IAccessAuthorizer.ACLType.DELETE, OzoneObj.ResourceType.KEY);
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, toKeyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    fromKey = omMetadataManager.getOzoneKey(volumeName, bucketName, fromKeyName);
                    toKey = omMetadataManager.getOzoneKey(volumeName, bucketName, toKeyName);
                    OmKeyInfo toKeyValue = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)toKey);
                    if (toKeyValue != null) {
                        throw new OMException("Key already exists " + toKeyName, OMException.ResultCodes.KEY_ALREADY_EXISTS);
                    }
                    fromKeyValue = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)fromKey);
                    if (fromKeyValue == null) {
                        throw new OMException("Key not found " + fromKey, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    fromKeyValue.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    fromKeyValue.setKeyName(toKeyName);
                    fromKeyValue.setModificationTime(keyArgs.getModificationTime());
                    Table keyTable = omMetadataManager.getKeyTable();
                    keyTable.addCacheEntry(new CacheKey((Object)fromKey), new CacheValue(Optional.absent(), trxnLogIndex));
                    keyTable.addCacheEntry(new CacheKey((Object)toKey), new CacheValue(Optional.of((Object)fromKeyValue), trxnLogIndex));
                    omClientResponse = new OMKeyRenameResponse(omResponse.setRenameKeyResponse(OzoneManagerProtocolProtos.RenameKeyResponse.newBuilder()).build(), fromKeyName, toKeyName, fromKeyValue);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyRenameResponse(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.RENAME_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("Rename Key is successfully completed for volume:{} bucket:{} fromKey:{} toKey:{}. ", new Object[]{volumeName, bucketName, fromKeyName, toKeyName});
                break;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumKeyRenameFails();
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Key: {} not found.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, fromKeyName});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyRenameRequest: {}", (Object)renameKeyRequest);
            }
        }
        return omClientResponse;
    }

    private Map<String, String> buildAuditMap(OzoneManagerProtocolProtos.KeyArgs keyArgs, OzoneManagerProtocolProtos.RenameKeyRequest renameKeyRequest) {
        Map<String, String> auditMap = this.buildKeyArgsAuditMap(keyArgs);
        auditMap.remove("key");
        auditMap.put("srcKey", keyArgs.getKeyName());
        auditMap.put("dstKey", renameKeyRequest.getToKeyName());
        return auditMap;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeyRenameRequest.java", OMKeyRenameRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMKeyRenameRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 75);
    }
}

