/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyDeleteRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyDeleteResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyDeleteRequestWithFSO
extends OMKeyDeleteRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyDeleteRequestWithFSO.class);

    public OMKeyDeleteRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        OMKeyDeleteResponseWithFSO omClientResponse;
        IOException exception;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.DeleteKeyRequest deleteKeyRequest;
        block16: {
            deleteKeyRequest = this.getOmRequest().getDeleteKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = deleteKeyRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            boolean recursive = keyArgs.getRecursive();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyDeletes();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            exception = null;
            boolean acquiredLock = false;
            omClientResponse = null;
            result = null;
            OmBucketInfo omBucketInfo = null;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkACLs(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.DELETE);
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    OzoneFileStatus keyStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, keyName, 0L);
                    if (keyStatus == null) {
                        throw new OMException("Key not found. Key:" + keyName, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    OmKeyInfo omKeyInfo = keyStatus.getKeyInfo();
                    String fileName = OzoneFSUtils.getFileName((String)keyName);
                    omKeyInfo.setKeyName(fileName);
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    String ozonePathKey = omMetadataManager.getOzonePathKey(omKeyInfo.getParentObjectID(), omKeyInfo.getFileName());
                    if (keyStatus.isDirectory()) {
                        if (!recursive && OMFileRequest.hasChildren(omKeyInfo, omMetadataManager)) {
                            throw new OMException("Directory is not empty. Key:" + keyName, OMException.ResultCodes.DIRECTORY_NOT_EMPTY);
                        }
                        omMetadataManager.getDirectoryTable().addCacheEntry(new CacheKey((Object)ozonePathKey), new CacheValue(Optional.absent(), trxnLogIndex));
                    } else {
                        omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)ozonePathKey), new CacheValue(Optional.absent(), trxnLogIndex));
                    }
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long quotaReleased = OMKeyDeleteRequestWithFSO.sumBlockLengths(omKeyInfo);
                    omBucketInfo.incrUsedBytes(-quotaReleased);
                    omBucketInfo.incrUsedNamespace(-1L);
                    omClientResponse = new OMKeyDeleteResponseWithFSO(omResponse.setDeleteKeyResponse(OzoneManagerProtocolProtos.DeleteKeyResponse.newBuilder()).build(), keyName, omKeyInfo, ozoneManager.isRatisEnabled(), omBucketInfo.copyObject(), keyStatus.isDirectory());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyDeleteResponseWithFSO(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_KEY, auditMap, exception, userInfo));
        switch (result) {
            case SUCCESS: {
                omMetrics.decNumKeys();
                LOG.debug("Key deleted. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                omMetrics.incNumKeyDeleteFails();
                LOG.error("Key delete failed. Volume:{}, Bucket:{}, Key:{}.", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyDeleteRequest: {}", (Object)deleteKeyRequest);
            }
        }
        return omClientResponse;
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

