/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyDeleteResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMKeyDeleteRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMKeyDeleteRequest.class);
    }

    public OMKeyDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.DeleteKeyRequest deleteKeyRequest = this.getOmRequest().getDeleteKeyRequest();
        Preconditions.checkNotNull((Object)deleteKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = deleteKeyRequest.getKeyArgs();
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(OMKeyDeleteRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName()));
        return this.getOmRequest().toBuilder().setDeleteKeyRequest(deleteKeyRequest.toBuilder().setKeyArgs(newKeyArgs)).setUserInfo(this.getUserIfNotExists(ozoneManager)).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        return this.validateAndUpdateCache(ozoneManager, trxnLogIndex, omDoubleBufferHelper, BucketLayout.DEFAULT);
    }

    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper, BucketLayout bucketLayout) {
        OMClientRequest.Result result;
        OMKeyDeleteResponse omClientResponse;
        IOException exception;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.DeleteKeyRequest deleteKeyRequest;
        block13: {
            deleteKeyRequest = this.getOmRequest().getDeleteKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = deleteKeyRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyDeletes();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            exception = null;
            boolean acquiredLock = false;
            omClientResponse = null;
            result = null;
            OmBucketInfo omBucketInfo = OmBucketInfo.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setCreationTime(Time.now()).setBucketLayout(bucketLayout).build();
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.DELETE, OzoneObj.ResourceType.KEY);
                    String objectKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)objectKey);
                    if (omKeyInfo == null) {
                        throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, keyName)), new CacheValue(Optional.absent(), trxnLogIndex));
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long quotaReleased = OMKeyDeleteRequest.sumBlockLengths(omKeyInfo);
                    omBucketInfo.incrUsedBytes(-quotaReleased);
                    omBucketInfo.incrUsedNamespace(-1L);
                    omClientResponse = new OMKeyDeleteResponse(omResponse.setDeleteKeyResponse(OzoneManagerProtocolProtos.DeleteKeyResponse.newBuilder()).build(), omKeyInfo, ozoneManager.isRatisEnabled(), omBucketInfo.copyObject());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyDeleteResponse(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_KEY, auditMap, exception, userInfo));
        switch (result) {
            case SUCCESS: {
                omMetrics.decNumKeys();
                LOG.debug("Key deleted. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                omMetrics.incNumKeyDeleteFails();
                LOG.error("Key delete failed. Volume:{}, Bucket:{}, Key:{}.", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyDeleteRequest: {}", (Object)deleteKeyRequest);
            }
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeyDeleteRequest.java", OMKeyDeleteRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMKeyDeleteRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 69);
    }
}

