/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCreateResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyCreateRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMKeyCreateRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMKeyCreateRequest.class);
    }

    public OMKeyCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.CreateKeyRequest createKeyRequest = this.getOmRequest().getCreateKeyRequest();
        Preconditions.checkNotNull((Object)createKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createKeyRequest.getKeyArgs();
        boolean checkKeyNameEnabled = ozoneManager.getConfiguration().getBoolean("ozone.om.keyname.character.check.enabled", false);
        if (checkKeyNameEnabled) {
            OmUtils.validateKeyName((String)keyArgs.getKeyName());
        }
        String keyPath = keyArgs.getKeyName();
        if (ozoneManager.getEnableFileSystemPaths() && (keyPath = OMKeyCreateRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyPath)).endsWith("/")) {
            throw new OMException("Invalid KeyPath, key names with trailing / are not allowed." + keyPath, OMException.ResultCodes.INVALID_KEY_NAME);
        }
        OzoneManagerProtocolProtos.CreateKeyRequest.Builder newCreateKeyRequest = null;
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = null;
        if (!keyArgs.getIsMultipartKey()) {
            HddsProtos.ReplicationType type;
            long scmBlockSize = ozoneManager.getScmBlockSize();
            long requestedSize = keyArgs.getDataSize() > 0L ? keyArgs.getDataSize() : scmBlockSize;
            boolean useRatis = ozoneManager.shouldUseRatis();
            HddsProtos.ReplicationFactor factor = keyArgs.getFactor();
            if (factor == null) {
                HddsProtos.ReplicationFactor replicationFactor = factor = useRatis ? HddsProtos.ReplicationFactor.THREE : HddsProtos.ReplicationFactor.ONE;
            }
            if ((type = keyArgs.getType()) == null) {
                type = useRatis ? HddsProtos.ReplicationType.RATIS : HddsProtos.ReplicationType.STAND_ALONE;
            }
            List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), type, factor, new ExcludeList(), requestedSize, scmBlockSize, ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMNodeId());
            newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setType(type).setFactor(factor).setDataSize(requestedSize);
            newKeyArgs.addAllKeyLocations((Iterable)omKeyLocationInfoList.stream().map(info -> info.getProtobuf(false, this.getOmRequest().getVersion())).collect(Collectors.toList()));
        } else {
            newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now());
        }
        newKeyArgs.setKeyName(keyPath);
        if (keyArgs.getIsMultipartKey()) {
            this.getFileEncryptionInfoForMpuKey(keyArgs, newKeyArgs, ozoneManager);
        } else {
            this.generateRequiredEncryptionInfo(keyArgs, newKeyArgs, ozoneManager);
        }
        newCreateKeyRequest = createKeyRequest.toBuilder().setKeyArgs(newKeyArgs).setClientID(UniqueId.next());
        return this.getOmRequest().toBuilder().setCreateKeyRequest(newCreateKeyRequest).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        int numMissingParents;
        OMClientRequest.Result result;
        IOException exception;
        OMKeyCreateResponse omClientResponse;
        OMMetrics omMetrics;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.CreateKeyRequest createKeyRequest;
        block12: {
            createKeyRequest = this.getOmRequest().getCreateKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = createKeyRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            String keyName = keyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyAllocates();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OmKeyInfo omKeyInfo = null;
            OmBucketInfo omBucketInfo = null;
            ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
            boolean acquireLock = false;
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            result = null;
            List<OmKeyInfo> missingParentInfos = null;
            numMissingParents = 0;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    acquireLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    String dbKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    OmKeyInfo dbKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().getIfExist((Object)dbKeyName);
                    if (dbKeyInfo != null) {
                        ozoneManager.getKeyManager().refresh(dbKeyInfo);
                    }
                    OmBucketInfo bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
                    if (ozoneManager.getEnableFileSystemPaths()) {
                        OMFileRequest.OMPathInfo pathInfo = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
                        OMFileRequest.OMDirectoryResult omDirectoryResult = pathInfo.getDirectoryResult();
                        List<OzoneAcl> inheritAcls = pathInfo.getAcls();
                        if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS) {
                            throw new OMException("Cannot write to directory. createIntermediateDirs behavior is enabled and hence / has special interpretation: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                        }
                        if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                            throw new OMException("Can not create file: " + keyName + " as there is already file in the given path", OMException.ResultCodes.NOT_A_FILE);
                        }
                        missingParentInfos = OMDirectoryCreateRequest.getAllParentInfo(ozoneManager, keyArgs, pathInfo.getMissingParents(), inheritAcls, trxnLogIndex);
                        OMFileRequest.addKeyTableCacheEntries(omMetadataManager, volumeName, bucketName, (Optional<OmKeyInfo>)Optional.absent(), (Optional<List<OmKeyInfo>>)Optional.of(missingParentInfos), trxnLogIndex);
                        numMissingParents = missingParentInfos.size();
                    }
                    omKeyInfo = this.prepareKeyInfo(omMetadataManager, keyArgs, dbKeyInfo, keyArgs.getDataSize(), locations, this.getFileEncryptionInfo(keyArgs), ozoneManager.getPrefixManager(), bucketInfo, trxnLogIndex, ozoneManager.getObjectIdFromTxId(trxnLogIndex), ozoneManager.isRatisEnabled());
                    long openVersion = omKeyInfo.getLatestVersionLocations().getVersion();
                    long clientID = createKeyRequest.getClientID();
                    String dbOpenKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
                    List newLocationList = keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList());
                    omKeyInfo.appendNewBlocks(newLocationList, false);
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long preAllocatedSpace = (long)newLocationList.size() * ozoneManager.getScmBlockSize() * (long)omKeyInfo.getReplicationConfig().getRequiredNodes();
                    this.checkBucketQuotaInBytes(omBucketInfo, preAllocatedSpace);
                    this.checkBucketQuotaInNamespace(omBucketInfo, 1L);
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbOpenKeyName), new CacheValue(Optional.of((Object)omKeyInfo), trxnLogIndex));
                    omBucketInfo.incrUsedBytes(preAllocatedSpace);
                    omBucketInfo.incrUsedNamespace(1L);
                    omResponse.setCreateKeyResponse(OzoneManagerProtocolProtos.CreateKeyResponse.newBuilder().setKeyInfo(omKeyInfo.getNetworkProtobuf(this.getOmRequest().getVersion(), keyArgs.getLatestVersionLocation())).setID(clientID).setOpenVersion(openVersion).build()).setCmdType(OzoneManagerProtocolProtos.Type.CreateKey);
                    omClientResponse = new OMKeyCreateResponse(omResponse.build(), omKeyInfo, missingParentInfos, clientID, omBucketInfo.copyObject());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omMetrics.incNumKeyAllocateFails();
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateKey);
                    omClientResponse = new OMKeyCreateResponse(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquireLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquireLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquireLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.ALLOCATE_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        this.logResult(createKeyRequest, omMetrics, exception, result, numMissingParents);
        return omClientResponse;
    }

    protected void logResult(OzoneManagerProtocolProtos.CreateKeyRequest createKeyRequest, OMMetrics omMetrics, IOException exception, OMClientRequest.Result result, int numMissingParents) {
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numMissingParents);
                LOG.debug("Key created. Volume:{}, Bucket:{}, Key:{}", new Object[]{createKeyRequest.getKeyArgs().getVolumeName(), createKeyRequest.getKeyArgs().getBucketName(), createKeyRequest.getKeyArgs().getKeyName()});
                break;
            }
            case FAILURE: {
                LOG.error("Key creation failed. Volume:{}, Bucket:{}, Key:{}. ", new Object[]{createKeyRequest.getKeyArgs().getVolumeName(), createKeyRequest.getKeyArgs().getBucketName(), createKeyRequest.getKeyArgs().getKeyName(), exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyCreateRequest: {}", (Object)createKeyRequest);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeyCreateRequest.java", OMKeyCreateRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMKeyCreateRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 83);
    }
}

