/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCommitResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;

public class OMKeyCommitRequestWithFSO
extends OMKeyCommitRequest {
    public OMKeyCommitRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        OMKeyCommitResponseWithFSO omClientResponse;
        OmKeyInfo omKeyInfo;
        IOException exception;
        Map<String, String> auditMap;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest;
        block10: {
            commitKeyRequest = this.getOmRequest().getCommitKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs commitKeyArgs = commitKeyRequest.getKeyArgs();
            volumeName = commitKeyArgs.getVolumeName();
            bucketName = commitKeyArgs.getBucketName();
            keyName = commitKeyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyCommits();
            auditLogger = ozoneManager.getAuditLogger();
            auditMap = this.buildKeyArgsAuditMap(commitKeyArgs);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            omKeyInfo = null;
            OmBucketInfo omBucketInfo = null;
            omClientResponse = null;
            boolean bucketLockAcquired = false;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            try {
                try {
                    commitKeyArgs = this.resolveBucketLink(ozoneManager, commitKeyArgs, auditMap);
                    volumeName = commitKeyArgs.getVolumeName();
                    bucketName = commitKeyArgs.getBucketName();
                    this.checkKeyAclsInOpenKeyTable(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, commitKeyRequest.getClientID());
                    String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
                    Iterator<Path> pathComponents = Paths.get(keyName, new String[0]).iterator();
                    String dbOpenFileKey = null;
                    ArrayList<OmKeyLocationInfo> locationInfoList = new ArrayList<OmKeyLocationInfo>();
                    for (OzoneManagerProtocolProtos.KeyLocation keyLocation : commitKeyArgs.getKeyLocationsList()) {
                        locationInfoList.add(OmKeyLocationInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyLocation)keyLocation));
                    }
                    bucketLockAcquired = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    String fileName = OzoneFSUtils.getFileName((String)keyName);
                    omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
                    long bucketId = omBucketInfo.getObjectID();
                    long parentID = OMFileRequest.getParentID(bucketId, pathComponents, keyName, omMetadataManager);
                    String dbFileKey = omMetadataManager.getOzonePathKey(parentID, fileName);
                    dbOpenFileKey = omMetadataManager.getOpenFileName(parentID, fileName, commitKeyRequest.getClientID());
                    omKeyInfo = OMFileRequest.getOmKeyInfoFromFileTable(true, omMetadataManager, dbOpenFileKey, keyName);
                    if (omKeyInfo == null) {
                        throw new OMException("Failed to commit key, as " + dbOpenFileKey + "entry is not found in the OpenKey table", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    omKeyInfo.setDataSize(commitKeyArgs.getDataSize());
                    omKeyInfo.setModificationTime(commitKeyArgs.getModificationTime());
                    omKeyInfo.updateLocationInfoList(locationInfoList, false);
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, dbFileKey, null, fileName, trxnLogIndex);
                    OMFileRequest.addFileTableCacheEntry(omMetadataManager, dbFileKey, omKeyInfo, fileName, trxnLogIndex);
                    long scmBlockSize = ozoneManager.getScmBlockSize();
                    int factor = omKeyInfo.getReplicationConfig().getRequiredNodes();
                    long correctedSpace = omKeyInfo.getDataSize() * (long)factor - (long)locationInfoList.size() * scmBlockSize * (long)factor;
                    omBucketInfo.incrUsedBytes(correctedSpace);
                    omClientResponse = new OMKeyCommitResponseWithFSO(omResponse.build(), omKeyInfo, dbFileKey, dbOpenFileKey, omBucketInfo.copyObject());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyCommitResponseWithFSO(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (bucketLockAcquired) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (bucketLockAcquired) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (bucketLockAcquired) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.COMMIT_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        this.processResult(commitKeyRequest, volumeName, bucketName, keyName, omMetrics, exception, omKeyInfo, result);
        return omClientResponse;
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

