/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCommitResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyCommitRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMKeyCommitRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMKeyCommitRequest.class);
    }

    public OMKeyCommitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest = this.getOmRequest().getCommitKeyRequest();
        Preconditions.checkNotNull((Object)commitKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = commitKeyRequest.getKeyArgs();
        boolean checkKeyNameEnabled = ozoneManager.getConfiguration().getBoolean("ozone.om.keyname.character.check.enabled", false);
        if (checkKeyNameEnabled) {
            OmUtils.validateKeyName((String)StringUtils.removeEnd((String)keyArgs.getKeyName(), (String)"._COPYING_"));
        }
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(OMKeyCommitRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName()));
        return this.getOmRequest().toBuilder().setCommitKeyRequest(commitKeyRequest.toBuilder().setKeyArgs(newKeyArgs)).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        OMKeyCommitResponse omClientResponse;
        OmKeyInfo omKeyInfo;
        IOException exception;
        Map<String, String> auditMap;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest;
        block14: {
            commitKeyRequest = this.getOmRequest().getCommitKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs commitKeyArgs = commitKeyRequest.getKeyArgs();
            volumeName = commitKeyArgs.getVolumeName();
            bucketName = commitKeyArgs.getBucketName();
            keyName = commitKeyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyCommits();
            auditLogger = ozoneManager.getAuditLogger();
            auditMap = this.buildKeyArgsAuditMap(commitKeyArgs);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            omKeyInfo = null;
            OmBucketInfo omBucketInfo = null;
            omClientResponse = null;
            boolean bucketLockAcquired = false;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            try {
                try {
                    commitKeyArgs = this.resolveBucketLink(ozoneManager, commitKeyArgs, auditMap);
                    volumeName = commitKeyArgs.getVolumeName();
                    bucketName = commitKeyArgs.getBucketName();
                    this.checkKeyAclsInOpenKeyTable(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, commitKeyRequest.getClientID());
                    String dbOzoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    String dbOpenKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, commitKeyRequest.getClientID());
                    ArrayList<OmKeyLocationInfo> locationInfoList = new ArrayList<OmKeyLocationInfo>();
                    for (OzoneManagerProtocolProtos.KeyLocation keyLocation : commitKeyArgs.getKeyLocationsList()) {
                        OmKeyLocationInfo locationInfo = OmKeyLocationInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyLocation)keyLocation);
                        if (ozoneManager.isGrpcBlockTokenEnabled()) {
                            locationInfo.setToken(null);
                        }
                        locationInfoList.add(locationInfo);
                    }
                    bucketLockAcquired = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    if (ozoneManager.getEnableFileSystemPaths()) {
                        if (this.checkDirectoryAlreadyExists(volumeName, bucketName, keyName, omMetadataManager)) {
                            throw new OMException("Can not create file: " + keyName + " as there is already directory in the given path", OMException.ResultCodes.NOT_A_FILE);
                        }
                        if (!"".equals(OzoneFSUtils.getParent((String)keyName)) && !this.checkDirectoryAlreadyExists(volumeName, bucketName, OzoneFSUtils.getParent((String)keyName), omMetadataManager)) {
                            throw new OMException("Cannot create file : " + keyName + " as parent directory doesn't exist", OMException.ResultCodes.DIRECTORY_NOT_FOUND);
                        }
                    }
                    if ((omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)dbOpenKey)) == null) {
                        throw new OMException("Failed to commit key, as " + dbOpenKey + "entry is not found in the OpenKey table", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    omKeyInfo.setDataSize(commitKeyArgs.getDataSize());
                    omKeyInfo.setModificationTime(commitKeyArgs.getModificationTime());
                    List allocatedLocationInfoList = omKeyInfo.getLatestVersionLocations().getLocationList();
                    omKeyInfo.updateLocationInfoList(locationInfoList, false);
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbOpenKey), new CacheValue(Optional.absent(), trxnLogIndex));
                    omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)dbOzoneKey), new CacheValue(Optional.of((Object)omKeyInfo), trxnLogIndex));
                    long scmBlockSize = ozoneManager.getScmBlockSize();
                    int factor = omKeyInfo.getReplicationConfig().getRequiredNodes();
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long correctedSpace = omKeyInfo.getDataSize() * (long)factor - (long)allocatedLocationInfoList.size() * scmBlockSize * (long)factor;
                    omBucketInfo.incrUsedBytes(correctedSpace);
                    omClientResponse = new OMKeyCommitResponse(omResponse.build(), omKeyInfo, dbOzoneKey, dbOpenKey, omBucketInfo.copyObject());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyCommitResponse(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (bucketLockAcquired) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (bucketLockAcquired) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (bucketLockAcquired) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.COMMIT_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        this.processResult(commitKeyRequest, volumeName, bucketName, keyName, omMetrics, exception, omKeyInfo, result);
        return omClientResponse;
    }

    protected void processResult(OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest, String volumeName, String bucketName, String keyName, OMMetrics omMetrics, IOException exception, OmKeyInfo omKeyInfo, OMClientRequest.Result result) {
        switch (result) {
            case SUCCESS: {
                if (omKeyInfo.getKeyLocationVersions().size() == 1) {
                    omMetrics.incNumKeys();
                }
                LOG.debug("Key committed. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                LOG.error("Key commit failed. Volume:{}, Bucket:{}, Key:{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                omMetrics.incNumKeyCommitFails();
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyCommitRequest: {}", (Object)commitKeyRequest);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeyCommitRequest.java", OMKeyCommitRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 76);
    }
}

