/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMAllocateBlockRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMAllocateBlockResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAllocateBlockRequestWithFSO
extends OMAllocateBlockRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMAllocateBlockRequestWithFSO.class);

    public OMAllocateBlockRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        IOException exception;
        OMClientResponse omClientResponse;
        Map<String, String> auditMap;
        AuditLogger auditLogger;
        block9: {
            OzoneManagerProtocolProtos.AllocateBlockRequest allocateBlockRequest = this.getOmRequest().getAllocateBlockRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = allocateBlockRequest.getKeyArgs();
            OzoneManagerProtocolProtos.KeyLocation blockLocation = allocateBlockRequest.getKeyLocation();
            Preconditions.checkNotNull((Object)blockLocation);
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            String keyName = keyArgs.getKeyName();
            long clientID = allocateBlockRequest.getClientID();
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBlockAllocateCalls();
            auditLogger = ozoneManager.getAuditLogger();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            auditMap.put("clientID", String.valueOf(clientID));
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            String openKeyName = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            OmKeyInfo openKeyInfo = null;
            exception = null;
            OmBucketInfo omBucketInfo = null;
            boolean acquiredLock = false;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAclsInOpenKeyTable(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, allocateBlockRequest.getClientID());
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    openKeyName = this.getOpenKeyName(volumeName, bucketName, keyName, clientID, ozoneManager);
                    openKeyInfo = this.getOpenKeyInfo(omMetadataManager, openKeyName, keyName);
                    if (openKeyInfo == null) {
                        throw new OMException("Open Key not found " + openKeyName, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    List<OmKeyLocationInfo> newLocationList = Collections.singletonList(OmKeyLocationInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyLocation)blockLocation));
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long preAllocatedSpace = (long)newLocationList.size() * ozoneManager.getScmBlockSize() * (long)openKeyInfo.getReplicationConfig().getRequiredNodes();
                    this.checkBucketQuotaInBytes(omBucketInfo, preAllocatedSpace);
                    openKeyInfo.appendNewBlocks(newLocationList, false);
                    openKeyInfo.setModificationTime(keyArgs.getModificationTime());
                    openKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    this.addOpenTableCacheEntry(trxnLogIndex, omMetadataManager, openKeyName, openKeyInfo);
                    omBucketInfo.incrUsedBytes(preAllocatedSpace);
                    omResponse.setAllocateBlockResponse(OzoneManagerProtocolProtos.AllocateBlockResponse.newBuilder().setKeyLocation(blockLocation).build());
                    omClientResponse = this.getOmClientResponse(clientID, omResponse, openKeyInfo, omBucketInfo.copyObject());
                    LOG.debug("Allocated block for Volume:{}, Bucket:{}, OpenKey:{}", new Object[]{volumeName, bucketName, openKeyName});
                }
                catch (IOException ex) {
                    omMetrics.incNumBlockAllocateCallFails();
                    exception = ex;
                    omClientResponse = new OMAllocateBlockResponseWithFSO(this.createErrorOMResponse(omResponse, exception));
                    LOG.error("Allocate Block failed. Volume:{}, Bucket:{}, OpenKey:{}. Exception:{}", new Object[]{volumeName, bucketName, openKeyName, exception});
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap, exception, this.getOmRequest().getUserInfo()));
        return omClientResponse;
    }

    private OmKeyInfo getOpenKeyInfo(OMMetadataManager omMetadataManager, String openKeyName, String keyName) throws IOException {
        String fileName = OzoneFSUtils.getFileName((String)keyName);
        return OMFileRequest.getOmKeyInfoFromFileTable(true, omMetadataManager, openKeyName, fileName);
    }

    private String getOpenKeyName(String volumeName, String bucketName, String keyName, long clientID, OzoneManager ozoneManager) throws IOException {
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
        long bucketId = omBucketInfo.getObjectID();
        String fileName = OzoneFSUtils.getFileName((String)keyName);
        Iterator<Path> pathComponents = Paths.get(keyName, new String[0]).iterator();
        long parentID = OMFileRequest.getParentID(bucketId, pathComponents, keyName, omMetadataManager);
        return omMetadataManager.getOpenFileName(parentID, fileName, clientID);
    }

    private void addOpenTableCacheEntry(long trxnLogIndex, OMMetadataManager omMetadataManager, String openKeyName, OmKeyInfo openKeyInfo) {
        String fileName = openKeyInfo.getFileName();
        OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, openKeyName, openKeyInfo, fileName, trxnLogIndex);
    }

    @NotNull
    private OMClientResponse getOmClientResponse(long clientID, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmKeyInfo openKeyInfo, OmBucketInfo omBucketInfo) {
        return new OMAllocateBlockResponseWithFSO(omResponse.build(), openKeyInfo, clientID, omBucketInfo);
    }
}

