/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMFileRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMFileRequest.class);

    private OMFileRequest() {
    }

    public static OMPathInfo verifyFilesInPath(@Nonnull OMMetadataManager omMetadataManager, @Nonnull String volumeName, @Nonnull String bucketName, @Nonnull String keyName, @Nonnull Path keyPath) throws IOException {
        String fileNameFromDetails = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
        String dirNameFromDetails = omMetadataManager.getOzoneDirKey(volumeName, bucketName, keyName);
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<OzoneAcl> inheritAcls = new ArrayList();
        OMDirectoryResult result = OMDirectoryResult.NONE;
        while (keyPath != null) {
            String pathName = keyPath.toString();
            String dbKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, pathName);
            String dbDirKeyName = omMetadataManager.getOzoneDirKey(volumeName, bucketName, pathName);
            if (omMetadataManager.getKeyTable().isExist((Object)dbKeyName)) {
                result = dbKeyName.equals(fileNameFromDetails) ? OMDirectoryResult.FILE_EXISTS : OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH;
            } else if (omMetadataManager.getKeyTable().isExist((Object)dbDirKeyName)) {
                if (dbDirKeyName.equals(dirNameFromDetails)) {
                    result = OMDirectoryResult.DIRECTORY_EXISTS;
                } else {
                    result = OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH;
                    inheritAcls = ((OmKeyInfo)omMetadataManager.getKeyTable().get((Object)dbDirKeyName)).getAcls();
                    LOG.trace("Acls inherited from parent " + dbDirKeyName + " are : " + inheritAcls);
                }
            } else if (!dbDirKeyName.equals(dirNameFromDetails)) {
                missing.add(keyPath.toString());
            }
            if (result != OMDirectoryResult.NONE) {
                LOG.trace("verifyFiles in Path : /" + volumeName + "/" + bucketName + "/" + keyName + ":" + (Object)((Object)result));
                return new OMPathInfo(missing, result, inheritAcls);
            }
            keyPath = keyPath.getParent();
        }
        if (inheritAcls.isEmpty()) {
            String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
            inheritAcls = ((OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey)).getAcls();
            LOG.trace("Acls inherited from bucket " + bucketName + " are : " + inheritAcls);
        }
        LOG.trace("verifyFiles in Path : " + volumeName + "/" + bucketName + "/" + keyName + ":" + (Object)((Object)result));
        return new OMPathInfo(missing, OMDirectoryResult.NONE, inheritAcls);
    }

    public static OMPathInfoWithFSO verifyDirectoryKeysInPath(@Nonnull OMMetadataManager omMetadataManager, @Nonnull String volumeName, @Nonnull String bucketName, @Nonnull String keyName, @Nonnull Path keyPath) throws IOException {
        String leafNodeName = OzoneFSUtils.getFileName((String)keyName);
        ArrayList<String> missing = new ArrayList<String>();
        OMDirectoryResult result = OMDirectoryResult.NONE;
        Iterator<Path> elements = keyPath.iterator();
        String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
        List inheritAcls = omBucketInfo.getAcls();
        long lastKnownParentId = omBucketInfo.getObjectID();
        String dbDirName = "";
        StringBuilder fullKeyPath = new StringBuilder(bucketKey);
        while (elements.hasNext()) {
            String fileName = elements.next().toString();
            fullKeyPath.append("/");
            fullKeyPath.append(fileName);
            if (missing.size() > 0) {
                if (!elements.hasNext()) continue;
                missing.add(fileName);
                continue;
            }
            String dbNodeName = omMetadataManager.getOzonePathKey(lastKnownParentId, fileName);
            OmDirectoryInfo omDirInfo = (OmDirectoryInfo)omMetadataManager.getDirectoryTable().get((Object)dbNodeName);
            if (omDirInfo != null) {
                dbDirName = String.valueOf(dbDirName) + omDirInfo.getName() + "/";
                if (elements.hasNext()) {
                    result = OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH;
                    lastKnownParentId = omDirInfo.getObjectID();
                    inheritAcls = omDirInfo.getAcls();
                    continue;
                }
                result = OMDirectoryResult.DIRECTORY_EXISTS;
                continue;
            }
            if (omMetadataManager.getKeyTable().isExist((Object)dbNodeName)) {
                if (elements.hasNext()) {
                    result = OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH;
                    break;
                }
                result = OMDirectoryResult.FILE_EXISTS;
                break;
            }
            if (!elements.hasNext()) continue;
            missing.add(fileName);
        }
        LOG.trace("verifyFiles/Directories in Path : /" + volumeName + "/" + bucketName + "/" + keyName + ":" + (Object)((Object)result));
        if (result == OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH || result == OMDirectoryResult.FILE_EXISTS) {
            return new OMPathInfoWithFSO(leafNodeName, lastKnownParentId, missing, result, inheritAcls, fullKeyPath.toString());
        }
        String dbDirKeyName = omMetadataManager.getOzoneDirKey(volumeName, bucketName, dbDirName);
        LOG.trace("Acls inherited from parent " + dbDirKeyName + " are : " + inheritAcls);
        return new OMPathInfoWithFSO(leafNodeName, lastKnownParentId, missing, result, inheritAcls);
    }

    public static void addKeyTableCacheEntries(OMMetadataManager omMetadataManager, String volumeName, String bucketName, Optional<OmKeyInfo> keyInfo, Optional<List<OmKeyInfo>> parentInfoList, long index) {
        for (OmKeyInfo parentInfo : (List)parentInfoList.get()) {
            omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, parentInfo.getKeyName())), new CacheValue(Optional.of((Object)parentInfo), index));
        }
        if (keyInfo.isPresent()) {
            omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, ((OmKeyInfo)keyInfo.get()).getKeyName())), new CacheValue(keyInfo, index));
        }
    }

    public static void addDirectoryTableCacheEntries(OMMetadataManager omMetadataManager, Optional<OmDirectoryInfo> dirInfo, Optional<List<OmDirectoryInfo>> missingParentInfos, long trxnLogIndex) {
        for (OmDirectoryInfo subDirInfo : (List)missingParentInfos.get()) {
            omMetadataManager.getDirectoryTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzonePathKey(subDirInfo.getParentObjectID(), subDirInfo.getName())), new CacheValue(Optional.of((Object)subDirInfo), trxnLogIndex));
        }
        if (dirInfo.isPresent()) {
            omMetadataManager.getDirectoryTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzonePathKey(((OmDirectoryInfo)dirInfo.get()).getParentObjectID(), ((OmDirectoryInfo)dirInfo.get()).getName())), new CacheValue(dirInfo, trxnLogIndex));
        }
    }

    public static void addOpenFileTableCacheEntry(OMMetadataManager omMetadataManager, String dbOpenFileName, @Nullable OmKeyInfo omFileInfo, String fileName, long trxnLogIndex) {
        Optional keyInfoOptional = Optional.absent();
        if (omFileInfo != null) {
            omFileInfo.setKeyName(fileName);
            omFileInfo.setFileName(fileName);
            keyInfoOptional = Optional.of((Object)omFileInfo);
        }
        omMetadataManager.getOpenKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).addCacheEntry(new CacheKey((Object)dbOpenFileName), new CacheValue(keyInfoOptional, trxnLogIndex));
    }

    public static void addFileTableCacheEntry(OMMetadataManager omMetadataManager, String dbFileKey, OmKeyInfo omFileInfo, String fileName, long trxnLogIndex) {
        omFileInfo.setKeyName(fileName);
        omFileInfo.setFileName(fileName);
        omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)dbFileKey), new CacheValue(Optional.of((Object)omFileInfo), trxnLogIndex));
    }

    public static void addToOpenFileTable(OMMetadataManager omMetadataMgr, BatchOperation batchOp, OmKeyInfo omFileInfo, long openKeySessionID) throws IOException {
        String dbOpenFileKey = omMetadataMgr.getOpenFileName(omFileInfo.getParentObjectID(), omFileInfo.getFileName(), openKeySessionID);
        omMetadataMgr.getOpenKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).putWithBatch(batchOp, (Object)dbOpenFileKey, (Object)omFileInfo);
    }

    public static String addToOpenFileTable(OMMetadataManager omMetadataMgr, BatchOperation batchOp, OmKeyInfo omFileInfo, String uploadID) throws IOException {
        String multipartFileKey = omMetadataMgr.getMultipartKey(omFileInfo.getParentObjectID(), omFileInfo.getFileName(), uploadID);
        omMetadataMgr.getOpenKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).putWithBatch(batchOp, (Object)multipartFileKey, (Object)omFileInfo);
        return multipartFileKey;
    }

    public static String addToFileTable(OMMetadataManager omMetadataMgr, BatchOperation batchOp, OmKeyInfo omFileInfo) throws IOException {
        String dbFileKey = omMetadataMgr.getOzonePathKey(omFileInfo.getParentObjectID(), omFileInfo.getFileName());
        omMetadataMgr.getKeyTable().putWithBatch(batchOp, (Object)dbFileKey, (Object)omFileInfo);
        return dbFileKey;
    }

    public static OmKeyInfo getOmKeyInfoFromFileTable(boolean openFileTable, OMMetadataManager omMetadataMgr, String dbOpenFileKey, String keyName) throws IOException {
        OmKeyInfo dbOmKeyInfo = openFileTable ? (OmKeyInfo)omMetadataMgr.getOpenKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).get((Object)dbOpenFileKey) : (OmKeyInfo)omMetadataMgr.getKeyTable().get((Object)dbOpenFileKey);
        if (dbOmKeyInfo != null) {
            dbOmKeyInfo.setKeyName(keyName);
        }
        return dbOmKeyInfo;
    }

    @Nullable
    public static OzoneFileStatus getOMKeyInfoIfExists(OMMetadataManager omMetadataMgr, String volumeName, String bucketName, String keyName, long scmBlockSize) throws IOException {
        OMFileRequest.validateBucket(omMetadataMgr, volumeName, bucketName);
        Path keyPath = Paths.get(keyName, new String[0]);
        Iterator<Path> elements = keyPath.iterator();
        String bucketKey = omMetadataMgr.getBucketKey(volumeName, bucketName);
        OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataMgr.getBucketTable().get((Object)bucketKey);
        long lastKnownParentId = omBucketInfo.getObjectID();
        OmDirectoryInfo omDirInfo = null;
        while (elements.hasNext()) {
            String fileName = elements.next().toString();
            String dbNodeName = omMetadataMgr.getOzonePathKey(lastKnownParentId, fileName);
            omDirInfo = (OmDirectoryInfo)omMetadataMgr.getDirectoryTable().get((Object)dbNodeName);
            if (omDirInfo != null) {
                lastKnownParentId = omDirInfo.getObjectID();
                continue;
            }
            if (!elements.hasNext()) {
                OmKeyInfo omKeyInfo = OMFileRequest.getOmKeyInfoFromFileTable(false, omMetadataMgr, dbNodeName, keyName);
                if (omKeyInfo == null) continue;
                return new OzoneFileStatus(omKeyInfo, scmBlockSize, false);
            }
            return null;
        }
        if (omDirInfo != null) {
            OmKeyInfo omKeyInfo = OMFileRequest.getOmKeyInfo(volumeName, bucketName, omDirInfo, keyName);
            return new OzoneFileStatus(omKeyInfo, scmBlockSize, true);
        }
        return null;
    }

    @NotNull
    public static OmKeyInfo getOmKeyInfo(String volumeName, String bucketName, OmDirectoryInfo dirInfo, String keyName) {
        OmKeyInfo.Builder builder = new OmKeyInfo.Builder();
        builder.setParentObjectID(dirInfo.getParentObjectID());
        builder.setKeyName(keyName);
        builder.setAcls(dirInfo.getAcls());
        builder.addAllMetadata(dirInfo.getMetadata());
        builder.setVolumeName(volumeName);
        builder.setBucketName(bucketName);
        builder.setCreationTime(dirInfo.getCreationTime());
        builder.setModificationTime(dirInfo.getModificationTime());
        builder.setObjectID(dirInfo.getObjectID());
        builder.setUpdateID(dirInfo.getUpdateID());
        builder.setFileName(dirInfo.getName());
        builder.setReplicationConfig((ReplicationConfig)new RatisReplicationConfig(HddsProtos.ReplicationFactor.ONE));
        builder.setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList())));
        return builder.build();
    }

    @NotNull
    public static String getAbsolutePath(String prefixName, String fileName) {
        if (Strings.isNullOrEmpty((String)prefixName)) {
            return fileName;
        }
        prefixName = OzoneFSUtils.addTrailingSlashIfNeeded((String)prefixName);
        return prefixName.concat(fileName);
    }

    public static OmDirectoryInfo getDirectoryInfo(OmKeyInfo keyInfo) {
        OmDirectoryInfo.Builder builder = new OmDirectoryInfo.Builder();
        builder.setParentObjectID(keyInfo.getParentObjectID());
        builder.setAcls(keyInfo.getAcls());
        builder.addAllMetadata(keyInfo.getMetadata());
        builder.setCreationTime(keyInfo.getCreationTime());
        builder.setModificationTime(keyInfo.getModificationTime());
        builder.setObjectID(keyInfo.getObjectID());
        builder.setUpdateID(keyInfo.getUpdateID());
        builder.setName(OzoneFSUtils.getFileName((String)keyInfo.getKeyName()));
        return builder.build();
    }

    public static void verifyToDirIsASubDirOfFromDirectory(String fromKeyName, String toKeyName, boolean isDir) throws OMException {
        if (!isDir) {
            return;
        }
        Path dstParent = Paths.get(toKeyName, new String[0]).getParent();
        while (dstParent != null) {
            if (Paths.get(fromKeyName, new String[0]).equals(dstParent)) {
                throw new OMException("Cannot rename a directory to its own subdirectory", OMException.ResultCodes.KEY_RENAME_ERROR);
            }
            dstParent = dstParent.getParent();
        }
    }

    public static long getToKeyNameParentId(String volumeName, String bucketName, String toKeyName, String fromKeyName, OMMetadataManager metaMgr) throws IOException {
        int totalDirsCount = OzoneFSUtils.getFileCount((String)toKeyName);
        if (totalDirsCount <= 1) {
            String bucketKey = metaMgr.getBucketKey(volumeName, bucketName);
            OmBucketInfo omBucketInfo = (OmBucketInfo)metaMgr.getBucketTable().get((Object)bucketKey);
            return omBucketInfo.getObjectID();
        }
        String toKeyParentDir = OzoneFSUtils.getParentDir((String)toKeyName);
        OzoneFileStatus toKeyParentDirStatus = OMFileRequest.getOMKeyInfoIfExists(metaMgr, volumeName, bucketName, toKeyParentDir, 0L);
        if (toKeyParentDirStatus == null) {
            throw new OMException(String.format("Failed to rename %s to %s, %s doesn't exist", fromKeyName, toKeyName, toKeyParentDir), OMException.ResultCodes.KEY_RENAME_ERROR);
        }
        if (toKeyParentDirStatus.isFile()) {
            throw new OMException(String.format("Failed to rename %s to %s, %s is a file", fromKeyName, toKeyName, toKeyParentDir), OMException.ResultCodes.KEY_RENAME_ERROR);
        }
        return toKeyParentDirStatus.getKeyInfo().getObjectID();
    }

    public static boolean hasChildren(OmKeyInfo omKeyInfo, OMMetadataManager metaMgr) throws IOException {
        return OMFileRequest.checkSubDirectoryExists(omKeyInfo, metaMgr) || OMFileRequest.checkSubFileExists(omKeyInfo, metaMgr);
    }

    private static boolean checkSubDirectoryExists(OmKeyInfo omKeyInfo, OMMetadataManager metaMgr) throws IOException {
        Table dirTable = metaMgr.getDirectoryTable();
        Iterator cacheIter = dirTable.cacheIterator();
        while (cacheIter.hasNext()) {
            Map.Entry entry = (Map.Entry)cacheIter.next();
            OmDirectoryInfo cacheOmDirInfo = (OmDirectoryInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (cacheOmDirInfo == null || !OMFileRequest.isImmediateChild(cacheOmDirInfo.getParentObjectID(), omKeyInfo.getObjectID())) continue;
            return true;
        }
        String seekDirInDB = metaMgr.getOzonePathKey(omKeyInfo.getObjectID(), "");
        TableIterator iterator = dirTable.iterator();
        iterator.seek((Object)seekDirInDB);
        if (iterator.hasNext()) {
            OmDirectoryInfo dirInfo = (OmDirectoryInfo)((Table.KeyValue)iterator.value()).getValue();
            return OMFileRequest.isImmediateChild(dirInfo.getParentObjectID(), omKeyInfo.getObjectID());
        }
        return false;
    }

    private static boolean checkSubFileExists(OmKeyInfo omKeyInfo, OMMetadataManager metaMgr) throws IOException {
        Table fileTable = metaMgr.getKeyTable();
        Iterator cacheIter = fileTable.cacheIterator();
        while (cacheIter.hasNext()) {
            Map.Entry entry = (Map.Entry)cacheIter.next();
            OmKeyInfo cacheOmFileInfo = (OmKeyInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (cacheOmFileInfo == null || !OMFileRequest.isImmediateChild(cacheOmFileInfo.getParentObjectID(), omKeyInfo.getObjectID())) continue;
            return true;
        }
        String seekFileInDB = metaMgr.getOzonePathKey(omKeyInfo.getObjectID(), "");
        TableIterator iterator = fileTable.iterator();
        iterator.seek((Object)seekFileInDB);
        if (iterator.hasNext()) {
            OmKeyInfo fileInfo = (OmKeyInfo)((Table.KeyValue)iterator.value()).getValue();
            return OMFileRequest.isImmediateChild(fileInfo.getParentObjectID(), omKeyInfo.getObjectID());
        }
        return false;
    }

    public static boolean isImmediateChild(long parentId, long ancestorId) {
        return parentId == ancestorId;
    }

    /*
     * Unable to fully structure code
     */
    public static long getParentID(long bucketId, Iterator<Path> pathComponents, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        lastKnownParentId = bucketId;
        if (pathComponents.hasNext()) ** GOTO lbl15
        return bucketId;
lbl-1000:
        // 1 sources

        {
            nodeName = pathComponents.next().toString();
            reachedLastPathComponent = pathComponents.hasNext() == false;
            dbNodeName = omMetadataManager.getOzonePathKey(lastKnownParentId, nodeName);
            omDirectoryInfo = (OmDirectoryInfo)omMetadataManager.getDirectoryTable().get((Object)dbNodeName);
            if (omDirectoryInfo != null) {
                if (reachedLastPathComponent) {
                    throw new OMException("Can not create file: " + keyName + " as there is already directory in the given path", OMException.ResultCodes.NOT_A_FILE);
                }
                lastKnownParentId = omDirectoryInfo.getObjectID();
                continue;
            }
            if (reachedLastPathComponent) break;
            throw new OMException("Failed to find parent directory of " + keyName + " in DirectoryTable", OMException.ResultCodes.KEY_NOT_FOUND);
lbl15:
            // 2 sources

            ** while (pathComponents.hasNext())
        }
lbl16:
        // 2 sources

        return lastKnownParentId;
    }

    public static void validateBucket(OMMetadataManager metadataManager, String volumeName, String bucketName) throws IOException {
        String bucketKey = metadataManager.getBucketKey(volumeName, bucketName);
        if (metadataManager.getBucketTable().get((Object)bucketKey) == null) {
            String volumeKey = metadataManager.getVolumeKey(volumeName);
            if (metadataManager.getVolumeTable().get((Object)volumeKey) == null) {
                LOG.error("volume not found: {}", (Object)volumeName);
                throw new OMException("Volume not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            LOG.error("bucket not found: {}/{} ", (Object)volumeName, (Object)bucketName);
            throw new OMException("Bucket not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
    }

    public static enum OMDirectoryResult {
        DIRECTORY_EXISTS_IN_GIVENPATH,
        FILE_EXISTS_IN_GIVENPATH,
        FILE_EXISTS,
        DIRECTORY_EXISTS,
        NONE;

    }

    public static class OMPathInfo {
        private OMDirectoryResult directoryResult;
        private List<String> missingParents;
        private List<OzoneAcl> acls;

        public OMPathInfo(List missingParents, OMDirectoryResult result, List<OzoneAcl> aclList) {
            this.missingParents = missingParents;
            this.directoryResult = result;
            this.acls = aclList;
        }

        public List getMissingParents() {
            return this.missingParents;
        }

        public OMDirectoryResult getDirectoryResult() {
            return this.directoryResult;
        }

        public List<OzoneAcl> getAcls() {
            return this.acls;
        }

        public boolean directParentExists() {
            return this.missingParents.isEmpty();
        }
    }

    public static class OMPathInfoWithFSO
    extends OMPathInfo {
        private String leafNodeName;
        private long lastKnownParentId;
        private long leafNodeObjectId;
        private String fileExistsInPath;

        public OMPathInfoWithFSO(String leafNodeName, long lastKnownParentId, List missingParents, OMDirectoryResult result, List<OzoneAcl> aclList, String fileExistsInPath) {
            super(missingParents, result, aclList);
            this.leafNodeName = leafNodeName;
            this.lastKnownParentId = lastKnownParentId;
            this.fileExistsInPath = fileExistsInPath;
        }

        public OMPathInfoWithFSO(String leafNodeName, long lastKnownParentId, List missingParents, OMDirectoryResult result, List<OzoneAcl> aclList) {
            this(leafNodeName, lastKnownParentId, missingParents, result, aclList, "");
        }

        public String getLeafNodeName() {
            return this.leafNodeName;
        }

        public long getLeafNodeObjectId() {
            return this.leafNodeObjectId;
        }

        public void setLeafNodeObjectId(long leafNodeObjectId) {
            this.leafNodeObjectId = leafNodeObjectId;
        }

        public void setLastKnownParentId(long lastKnownParentId) {
            this.lastKnownParentId = lastKnownParentId;
        }

        public long getLastKnownParentId() {
            return this.lastKnownParentId;
        }

        public String getFileExistsInPath() {
            return this.fileExistsInPath;
        }
    }
}

