/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Optional;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequestWithFSO;
import org.apache.hadoop.ozone.om.request.file.OMFileCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMFileCreateResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFileCreateRequestWithFSO
extends OMFileCreateRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMFileCreateRequestWithFSO.class);

    public OMFileCreateRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        IOException exception;
        OMFileCreateResponseWithFSO omClientResponse;
        int numKeysCreated;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest;
        block16: {
            createFileRequest = this.getOmRequest().getCreateFileRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = createFileRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            boolean isRecursive = createFileRequest.getIsRecursive();
            if (LOG.isDebugEnabled()) {
                LOG.debug("File create for : " + volumeName + "/" + bucketName + "/" + keyName + ":" + isRecursive);
            }
            boolean isOverWrite = createFileRequest.getIsOverwrite();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumCreateFile();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            OmBucketInfo omBucketInfo = null;
            ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
            numKeysCreated = 0;
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            result = null;
            try {
                try {
                    String dbFileKey;
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    if (keyName.length() == 0) {
                        throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                    }
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    OmKeyInfo dbFileInfo = null;
                    OMFileRequest.OMPathInfoWithFSO pathInfoFSO = OMFileRequest.verifyDirectoryKeysInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
                    if (pathInfoFSO.getDirectoryResult() == OMFileRequest.OMDirectoryResult.FILE_EXISTS && (dbFileInfo = OMFileRequest.getOmKeyInfoFromFileTable(false, omMetadataManager, dbFileKey = omMetadataManager.getOzonePathKey(pathInfoFSO.getLastKnownParentId(), pathInfoFSO.getLeafNodeName()), keyName)) != null) {
                        ozoneManager.getKeyManager().refresh(dbFileInfo);
                    }
                    this.checkDirectoryResult(keyName, isOverWrite, pathInfoFSO.getDirectoryResult());
                    if (!isRecursive) {
                        this.checkAllParentsExist(keyArgs, pathInfoFSO);
                    }
                    List<OmDirectoryInfo> missingParentInfos = OMDirectoryCreateRequestWithFSO.getAllMissingParentDirInfo(ozoneManager, keyArgs, pathInfoFSO, trxnLogIndex);
                    numKeysCreated = missingParentInfos.size();
                    OmBucketInfo bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
                    OmKeyInfo omFileInfo = this.prepareFileInfo(omMetadataManager, keyArgs, dbFileInfo, keyArgs.getDataSize(), locations, this.getFileEncryptionInfo(keyArgs), ozoneManager.getPrefixManager(), bucketInfo, pathInfoFSO, trxnLogIndex, pathInfoFSO.getLeafNodeObjectId(), ozoneManager.isRatisEnabled());
                    long openVersion = omFileInfo.getLatestVersionLocations().getVersion();
                    long clientID = createFileRequest.getClientID();
                    String dbOpenFileName = omMetadataManager.getOpenFileName(pathInfoFSO.getLastKnownParentId(), pathInfoFSO.getLeafNodeName(), clientID);
                    List newLocationList = keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList());
                    omFileInfo.appendNewBlocks(newLocationList, false);
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long preAllocatedSpace = (long)newLocationList.size() * ozoneManager.getScmBlockSize() * (long)omFileInfo.getReplicationConfig().getRequiredNodes();
                    this.checkBucketQuotaInBytes(omBucketInfo, preAllocatedSpace);
                    this.checkBucketQuotaInNamespace(omBucketInfo, 1L);
                    OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, dbOpenFileName, omFileInfo, pathInfoFSO.getLeafNodeName(), trxnLogIndex);
                    OMFileRequest.addDirectoryTableCacheEntries(omMetadataManager, (Optional<OmDirectoryInfo>)Optional.absent(), (Optional<List<OmDirectoryInfo>>)Optional.of(missingParentInfos), trxnLogIndex);
                    omBucketInfo.incrUsedBytes(preAllocatedSpace);
                    omBucketInfo.incrUsedNamespace(1L);
                    int clientVersion = this.getOmRequest().getVersion();
                    omResponse.setCreateFileResponse(OzoneManagerProtocolProtos.CreateFileResponse.newBuilder().setKeyInfo(omFileInfo.getNetworkProtobuf(keyName, clientVersion, keyArgs.getLatestVersionLocation())).setID(clientID).setOpenVersion(openVersion).build()).setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                    omClientResponse = new OMFileCreateResponseWithFSO(omResponse.build(), omFileInfo, missingParentInfos, clientID, omBucketInfo.copyObject());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omMetrics.incNumCreateFileFails();
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                    omClientResponse = new OMFileCreateResponseWithFSO(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.CREATE_FILE, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numKeysCreated);
                LOG.debug("File created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                LOG.error("File create failed. Volume:{}, Bucket:{}, Key:{}.", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMFileCreateRequest: {}", (Object)createFileRequest);
            }
        }
        return omClientResponse;
    }
}

