/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMFileCreateResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFileCreateRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMFileCreateRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMFileCreateRequest.class);
    }

    public OMFileCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        HddsProtos.ReplicationType type;
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest = this.getOmRequest().getCreateFileRequest();
        Preconditions.checkNotNull((Object)createFileRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createFileRequest.getKeyArgs();
        boolean checkKeyNameEnabled = ozoneManager.getConfiguration().getBoolean("ozone.om.keyname.character.check.enabled", false);
        if (checkKeyNameEnabled) {
            OmUtils.validateKeyName((String)StringUtils.removeEnd((String)keyArgs.getKeyName(), (String)"._COPYING_"));
        }
        if (keyArgs.getKeyName().length() == 0) {
            return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).build();
        }
        long scmBlockSize = ozoneManager.getScmBlockSize();
        long requestedSize = keyArgs.getDataSize() > 0L ? keyArgs.getDataSize() : scmBlockSize;
        boolean useRatis = ozoneManager.shouldUseRatis();
        HddsProtos.ReplicationFactor factor = keyArgs.getFactor();
        if (factor == null) {
            HddsProtos.ReplicationFactor replicationFactor = factor = useRatis ? HddsProtos.ReplicationFactor.THREE : HddsProtos.ReplicationFactor.ONE;
        }
        if ((type = keyArgs.getType()) == null) {
            type = useRatis ? HddsProtos.ReplicationType.RATIS : HddsProtos.ReplicationType.STAND_ALONE;
        }
        List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), type, factor, new ExcludeList(), requestedSize, scmBlockSize, ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMNodeId());
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setType(type).setFactor(factor).setDataSize(requestedSize);
        newKeyArgs.addAllKeyLocations((Iterable)omKeyLocationInfoList.stream().map(info -> info.getProtobuf(this.getOmRequest().getVersion())).collect(Collectors.toList()));
        this.generateRequiredEncryptionInfo(keyArgs, newKeyArgs, ozoneManager);
        OzoneManagerProtocolProtos.CreateFileRequest.Builder newCreateFileRequest = createFileRequest.toBuilder().setKeyArgs(newKeyArgs).setClientID(UniqueId.next());
        return this.getOmRequest().toBuilder().setCreateFileRequest(newCreateFileRequest).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMClientRequest.Result result;
        IOException exception;
        OMFileCreateResponse omClientResponse;
        OMMetrics omMetrics;
        int numMissingParents;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest;
        block16: {
            createFileRequest = this.getOmRequest().getCreateFileRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = createFileRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            numMissingParents = 0;
            boolean isRecursive = createFileRequest.getIsRecursive();
            if (LOG.isDebugEnabled()) {
                LOG.debug("File create for : " + volumeName + "/" + bucketName + "/" + keyName + ":" + isRecursive);
            }
            boolean isOverWrite = createFileRequest.getIsOverwrite();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumCreateFile();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            OmKeyInfo omKeyInfo = null;
            OmBucketInfo omBucketInfo = null;
            ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            result = null;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    if (keyName.length() == 0) {
                        throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                    }
                    String ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    OmKeyInfo dbKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().getIfExist((Object)ozoneKey);
                    if (dbKeyInfo != null) {
                        ozoneManager.getKeyManager().refresh(dbKeyInfo);
                    }
                    OMFileRequest.OMPathInfo pathInfo = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
                    OMFileRequest.OMDirectoryResult omDirectoryResult = pathInfo.getDirectoryResult();
                    List<OzoneAcl> inheritAcls = pathInfo.getAcls();
                    this.checkDirectoryResult(keyName, isOverWrite, omDirectoryResult);
                    if (!isRecursive) {
                        this.checkAllParentsExist(keyArgs, pathInfo);
                    }
                    OmBucketInfo bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
                    omKeyInfo = this.prepareKeyInfo(omMetadataManager, keyArgs, dbKeyInfo, keyArgs.getDataSize(), locations, this.getFileEncryptionInfo(keyArgs), ozoneManager.getPrefixManager(), bucketInfo, trxnLogIndex, ozoneManager.getObjectIdFromTxId(trxnLogIndex), ozoneManager.isRatisEnabled());
                    long openVersion = omKeyInfo.getLatestVersionLocations().getVersion();
                    long clientID = createFileRequest.getClientID();
                    String dbOpenKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
                    List<OmKeyInfo> missingParentInfos = OMDirectoryCreateRequest.getAllParentInfo(ozoneManager, keyArgs, pathInfo.getMissingParents(), inheritAcls, trxnLogIndex);
                    List newLocationList = keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList());
                    omKeyInfo.appendNewBlocks(newLocationList, false);
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long preAllocatedSpace = (long)newLocationList.size() * ozoneManager.getScmBlockSize() * (long)omKeyInfo.getReplicationConfig().getRequiredNodes();
                    this.checkBucketQuotaInBytes(omBucketInfo, preAllocatedSpace);
                    this.checkBucketQuotaInNamespace(omBucketInfo, 1L);
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbOpenKeyName), new CacheValue(Optional.of((Object)omKeyInfo), trxnLogIndex));
                    OMFileRequest.addKeyTableCacheEntries(omMetadataManager, volumeName, bucketName, (Optional<OmKeyInfo>)Optional.absent(), (Optional<List<OmKeyInfo>>)Optional.of(missingParentInfos), trxnLogIndex);
                    omBucketInfo.incrUsedBytes(preAllocatedSpace);
                    omBucketInfo.incrUsedNamespace(1L);
                    numMissingParents = missingParentInfos.size();
                    omResponse.setCreateFileResponse(OzoneManagerProtocolProtos.CreateFileResponse.newBuilder().setKeyInfo(omKeyInfo.getNetworkProtobuf(this.getOmRequest().getVersion(), keyArgs.getLatestVersionLocation())).setID(clientID).setOpenVersion(openVersion).build()).setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                    omClientResponse = new OMFileCreateResponse(omResponse.build(), omKeyInfo, missingParentInfos, clientID, omBucketInfo.copyObject());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omMetrics.incNumCreateFileFails();
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                    omClientResponse = new OMFileCreateResponse(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.CREATE_FILE, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numMissingParents);
                LOG.debug("File created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                LOG.error("File create failed. Volume:{}, Bucket:{}, Key{}.", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMFileCreateRequest: {}", (Object)createFileRequest);
            }
        }
        return omClientResponse;
    }

    protected void checkDirectoryResult(String keyName, boolean isOverWrite, OMFileRequest.OMDirectoryResult omDirectoryResult) throws OMException {
        if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS) {
            if (!isOverWrite) {
                throw new OMException("File " + keyName + " already exists", OMException.ResultCodes.FILE_ALREADY_EXISTS);
            }
        } else {
            if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS) {
                throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
            }
            if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                throw new OMException("Can not create file: " + keyName + " as there " + "is already file in the given path", OMException.ResultCodes.NOT_A_FILE);
            }
        }
    }

    protected void checkAllParentsExist(OzoneManagerProtocolProtos.KeyArgs keyArgs, OMFileRequest.OMPathInfo pathInfo) throws IOException {
        String keyName = keyArgs.getKeyName();
        if (!pathInfo.directParentExists()) {
            throw new OMException("Cannot create file : " + keyName + " as one of parent directory is not created", OMException.ResultCodes.DIRECTORY_NOT_FOUND);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMFileCreateRequest.java", OMFileCreateRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.file.OMFileCreateRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 83);
    }
}

