/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Optional;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMDirectoryCreateResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDirectoryCreateRequestWithFSO
extends OMDirectoryCreateRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMDirectoryCreateRequestWithFSO.class);

    public OMDirectoryCreateRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        OMDirectoryCreateRequest.Result result;
        OMDirectoryCreateResponseWithFSO omClientResponse;
        IOException exception;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        int numKeysCreated;
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest;
        block12: {
            createDirectoryRequest = this.getOmRequest().getCreateDirectoryRequest();
            keyArgs = createDirectoryRequest.getKeyArgs();
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            String keyName = keyArgs.getKeyName();
            numKeysCreated = 0;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omResponse.setCreateDirectoryResponse(OzoneManagerProtocolProtos.CreateDirectoryResponse.newBuilder());
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumCreateDirectory();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            exception = null;
            omClientResponse = null;
            result = OMDirectoryCreateRequest.Result.FAILURE;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    if (keyName.length() == 0) {
                        throw new OMException("Directory create failed. Cannot create directory at root of the filesystem", OMException.ResultCodes.CANNOT_CREATE_DIRECTORY_AT_ROOT);
                    }
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    Path keyPath = Paths.get(keyName, new String[0]);
                    OMFileRequest.OMPathInfoWithFSO omPathInfo = OMFileRequest.verifyDirectoryKeysInPath(omMetadataManager, volumeName, bucketName, keyName, keyPath);
                    OMFileRequest.OMDirectoryResult omDirectoryResult = omPathInfo.getDirectoryResult();
                    if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS || omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                        throw new OMException("Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName + " as " + "file:" + omPathInfo.getFileExistsInPath() + " already exists", OMException.ResultCodes.FILE_ALREADY_EXISTS);
                    }
                    if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH || omDirectoryResult == OMFileRequest.OMDirectoryResult.NONE) {
                        List<OmDirectoryInfo> missingParentInfos = OMDirectoryCreateRequestWithFSO.getAllMissingParentDirInfo(ozoneManager, keyArgs, omPathInfo, trxnLogIndex);
                        OmDirectoryInfo dirInfo = OMDirectoryCreateRequestWithFSO.createDirectoryInfoWithACL(omPathInfo.getLeafNodeName(), keyArgs, omPathInfo.getLeafNodeObjectId(), omPathInfo.getLastKnownParentId(), trxnLogIndex, OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList()));
                        OMFileRequest.addDirectoryTableCacheEntries(omMetadataManager, (Optional<OmDirectoryInfo>)Optional.of((Object)dirInfo), (Optional<List<OmDirectoryInfo>>)Optional.of(missingParentInfos), trxnLogIndex);
                        numKeysCreated = missingParentInfos.size() + 1;
                        result = OMDirectoryCreateRequest.Result.SUCCESS;
                        omClientResponse = new OMDirectoryCreateResponseWithFSO(omResponse.build(), dirInfo, missingParentInfos, result);
                    } else {
                        result = OMDirectoryCreateRequest.Result.DIRECTORY_ALREADY_EXISTS;
                        omResponse.setStatus(OzoneManagerProtocolProtos.Status.DIRECTORY_ALREADY_EXISTS);
                        omClientResponse = new OMDirectoryCreateResponseWithFSO(omResponse.build(), result);
                    }
                }
                catch (IOException ex) {
                    exception = ex;
                    omClientResponse = new OMDirectoryCreateResponseWithFSO(this.createErrorOMResponse(omResponse, exception), result);
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.CREATE_DIRECTORY, auditMap, exception, userInfo));
        this.logResult(createDirectoryRequest, keyArgs, omMetrics, numKeysCreated, result, exception);
        return omClientResponse;
    }

    private void logResult(OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest, OzoneManagerProtocolProtos.KeyArgs keyArgs, OMMetrics omMetrics, int numKeys, OMDirectoryCreateRequest.Result result, IOException exception) {
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numKeys);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Directory created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case DIRECTORY_ALREADY_EXISTS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Directory already exists. Volume:{}, Bucket:{}, Key{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            case FAILURE: {
                omMetrics.incNumCreateDirectoryFails();
                LOG.error("Directory creation failed. Volume:{}, Bucket:{}, Key{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMDirectoryCreateRequest: {}", (Object)createDirectoryRequest);
            }
        }
    }

    public static List<OmDirectoryInfo> getAllMissingParentDirInfo(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs keyArgs, OMFileRequest.OMPathInfoWithFSO pathInfo, long trxnLogIndex) throws IOException {
        ArrayList<OmDirectoryInfo> missingParentInfos = new ArrayList<OmDirectoryInfo>();
        long baseObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
        long maxObjId = baseObjId + OMDirectoryCreateRequestWithFSO.getMaxNumOfRecursiveDirs();
        long objectCount = 1L;
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        long lastKnownParentId = pathInfo.getLastKnownParentId();
        List missingParents = pathInfo.getMissingParents();
        List<OzoneAcl> inheritAcls = pathInfo.getAcls();
        for (String missingKey : missingParents) {
            long nextObjId = baseObjId + objectCount;
            if (nextObjId > maxObjId) {
                throw new OMException("Too many directories in path. Exceeds limit of " + OMDirectoryCreateRequestWithFSO.getMaxNumOfRecursiveDirs() + ". Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName, OMException.ResultCodes.INVALID_KEY_NAME);
            }
            LOG.debug("missing parent {} getting added to DirectoryTable", (Object)missingKey);
            OmDirectoryInfo dirInfo = OMDirectoryCreateRequestWithFSO.createDirectoryInfoWithACL(missingKey, keyArgs, nextObjId, lastKnownParentId, trxnLogIndex, inheritAcls);
            ++objectCount;
            missingParentInfos.add(dirInfo);
            lastKnownParentId = nextObjId;
        }
        pathInfo.setLastKnownParentId(lastKnownParentId);
        pathInfo.setLeafNodeObjectId(baseObjId + objectCount);
        return missingParentInfos;
    }

    private static OmDirectoryInfo createDirectoryInfoWithACL(String dirName, OzoneManagerProtocolProtos.KeyArgs keyArgs, long objectId, long parentObjectId, long transactionIndex, List<OzoneAcl> inheritAcls) {
        return OmDirectoryInfo.newBuilder().setName(dirName).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setObjectID(objectId).setUpdateID(transactionIndex).setParentObjectID(parentObjectId).setAcls(inheritAcls).build();
    }
}

