/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMDirectoryCreateResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDirectoryCreateRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static final long MAX_NUM_OF_RECURSIVE_DIRS = 255L;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMDirectoryCreateRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMDirectoryCreateRequest.class);
    }

    public OMDirectoryCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest = this.getOmRequest().getCreateDirectoryRequest();
        Preconditions.checkNotNull((Object)createDirectoryRequest);
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = createDirectoryRequest.getKeyArgs().toBuilder().setModificationTime(Time.now());
        OzoneManagerProtocolProtos.CreateDirectoryRequest.Builder newCreateDirectoryRequest = createDirectoryRequest.toBuilder().setKeyArgs(newKeyArgs);
        return this.getOmRequest().toBuilder().setCreateDirectoryRequest(newCreateDirectoryRequest).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        int numMissingParents;
        Result result;
        OMDirectoryCreateResponse omClientResponse;
        IOException exception;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest;
        block12: {
            createDirectoryRequest = this.getOmRequest().getCreateDirectoryRequest();
            keyArgs = createDirectoryRequest.getKeyArgs();
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            String keyName = keyArgs.getKeyName();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omResponse.setCreateDirectoryResponse(OzoneManagerProtocolProtos.CreateDirectoryResponse.newBuilder());
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumCreateDirectory();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            exception = null;
            omClientResponse = null;
            result = Result.FAILURE;
            numMissingParents = 0;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    if (keyName.length() == 0) {
                        throw new OMException("Directory create failed. Cannot create directory at root of the filesystem", OMException.ResultCodes.CANNOT_CREATE_DIRECTORY_AT_ROOT);
                    }
                    acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    Path keyPath = Paths.get(keyName, new String[0]);
                    OMFileRequest.OMPathInfo omPathInfo = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, keyPath);
                    OMFileRequest.OMDirectoryResult omDirectoryResult = omPathInfo.getDirectoryResult();
                    OmKeyInfo dirKeyInfo = null;
                    if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS || omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                        throw new OMException("Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName, OMException.ResultCodes.FILE_ALREADY_EXISTS);
                    }
                    if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH || omDirectoryResult == OMFileRequest.OMDirectoryResult.NONE) {
                        List missingParents = omPathInfo.getMissingParents();
                        long baseObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
                        List<OzoneAcl> inheritAcls = omPathInfo.getAcls();
                        dirKeyInfo = OMDirectoryCreateRequest.createDirectoryKeyInfoWithACL(keyName, keyArgs, baseObjId, OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList()), trxnLogIndex);
                        List<OmKeyInfo> missingParentInfos = OMDirectoryCreateRequest.getAllParentInfo(ozoneManager, keyArgs, missingParents, inheritAcls, trxnLogIndex);
                        numMissingParents = missingParentInfos.size();
                        OMFileRequest.addKeyTableCacheEntries(omMetadataManager, volumeName, bucketName, (Optional<OmKeyInfo>)Optional.of((Object)dirKeyInfo), (Optional<List<OmKeyInfo>>)Optional.of(missingParentInfos), trxnLogIndex);
                        result = Result.SUCCESS;
                        omClientResponse = new OMDirectoryCreateResponse(omResponse.build(), dirKeyInfo, missingParentInfos, result);
                    } else {
                        result = Result.DIRECTORY_ALREADY_EXISTS;
                        omResponse.setStatus(OzoneManagerProtocolProtos.Status.DIRECTORY_ALREADY_EXISTS);
                        omClientResponse = new OMDirectoryCreateResponse(omResponse.build(), result);
                    }
                }
                catch (IOException ex) {
                    exception = ex;
                    omClientResponse = new OMDirectoryCreateResponse(this.createErrorOMResponse(omResponse, exception), result);
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.CREATE_DIRECTORY, auditMap, exception, userInfo));
        this.logResult(createDirectoryRequest, keyArgs, omMetrics, result, exception, numMissingParents);
        return omClientResponse;
    }

    public static List<OmKeyInfo> getAllParentInfo(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs keyArgs, List<String> missingParents, List<OzoneAcl> inheritAcls, long trxnLogIndex) throws IOException {
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        ArrayList<OmKeyInfo> missingParentInfos = new ArrayList<OmKeyInfo>();
        long baseObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
        long maxObjId = baseObjId + 255L;
        long objectCount = 1L;
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        for (String missingKey : missingParents) {
            long nextObjId = baseObjId + objectCount;
            if (nextObjId > maxObjId) {
                throw new OMException("Too many directories in path. Exceeds limit of 255. Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName, OMException.ResultCodes.INVALID_KEY_NAME);
            }
            LOG.debug("missing parent {} getting added to KeyTable", (Object)missingKey);
            OmKeyInfo parentKeyInfo = OMDirectoryCreateRequest.createDirectoryKeyInfoWithACL(missingKey, keyArgs, nextObjId, inheritAcls, trxnLogIndex);
            ++objectCount;
            missingParentInfos.add(parentKeyInfo);
            omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, parentKeyInfo.getKeyName())), new CacheValue(Optional.of((Object)parentKeyInfo), trxnLogIndex));
        }
        return missingParentInfos;
    }

    private void logResult(OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest, OzoneManagerProtocolProtos.KeyArgs keyArgs, OMMetrics omMetrics, Result result, IOException exception, int numMissingParents) {
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numMissingParents + 1);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Directory created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case DIRECTORY_ALREADY_EXISTS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Directory already exists. Volume:{}, Bucket:{}, Key{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            case FAILURE: {
                omMetrics.incNumCreateDirectoryFails();
                LOG.error("Directory creation failed. Volume:{}, Bucket:{}, Key{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMDirectoryCreateRequest: {}", (Object)createDirectoryRequest);
            }
        }
    }

    public static OmKeyInfo createDirectoryKeyInfoWithACL(String keyName, OzoneManagerProtocolProtos.KeyArgs keyArgs, long objectId, List<OzoneAcl> inheritAcls, long transactionIndex) {
        return OMDirectoryCreateRequest.dirKeyInfoBuilderNoACL(keyName, keyArgs, objectId).setAcls(inheritAcls).setUpdateID(transactionIndex).build();
    }

    private static OmKeyInfo.Builder dirKeyInfoBuilderNoACL(String keyName, OzoneManagerProtocolProtos.KeyArgs keyArgs, long objectId) {
        String dirName = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        return new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(dirName).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(0L).setReplicationConfig(ReplicationConfig.fromTypeAndFactor((HddsProtos.ReplicationType)keyArgs.getType(), (HddsProtos.ReplicationFactor)keyArgs.getFactor())).setObjectID(objectId).setUpdateID(objectId);
    }

    static long getMaxNumOfRecursiveDirs() {
        return 255L;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMDirectoryCreateRequest.java", OMDirectoryCreateRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 108);
    }

    public static enum Result {
        SUCCESS,
        DIRECTORY_ALREADY_EXISTS,
        FAILURE;

    }
}

