/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket.acl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketAclRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.acl.OMBucketAclResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.util.BooleanBiFunction;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketSetAclRequest
extends OMBucketAclRequest {
    private static final Logger LOG;
    private static BooleanBiFunction<List<OzoneAcl>, OmBucketInfo> bucketAddAclOp;
    private String path;
    private List<OzoneAcl> ozoneAcls;
    private OzoneObj obj;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMBucketSetAclRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMBucketSetAclRequest.class);
        bucketAddAclOp = (ozoneAcls, omBucketInfo) -> omBucketInfo.setAcls(ozoneAcls);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.SetAclRequest.Builder setAclRequestBuilder = this.getOmRequest().getSetAclRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setSetAclRequest(setAclRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    public OMBucketSetAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, bucketAddAclOp);
        OzoneManagerProtocolProtos.SetAclRequest setAclRequest = this.getOmRequest().getSetAclRequest();
        this.obj = OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)setAclRequest.getObj());
        this.path = this.obj.getPath();
        this.ozoneAcls = new ArrayList<OzoneAcl>();
        setAclRequest.getAclList().forEach(aclInfo -> {
            boolean bl = this.ozoneAcls.add(OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)aclInfo));
        });
    }

    @Override
    List<OzoneAcl> getAcls() {
        return this.ozoneAcls;
    }

    @Override
    String getPath() {
        return this.path;
    }

    @Override
    OzoneObj getObject() {
        return this.obj;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmBucketInfo omBucketInfo, boolean operationResult) {
        omResponse.setSuccess(operationResult);
        omResponse.setSetAclResponse(OzoneManagerProtocolProtos.SetAclResponse.newBuilder().setResponse(operationResult));
        return new OMBucketAclResponse(omResponse.build(), omBucketInfo);
    }

    @Override
    void onComplete(boolean operationResult, IOException exception, OMMetrics omMetrics, AuditLogger auditLogger, Map<String, String> auditMap) {
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.SET_ACL, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (operationResult) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set acl: {} for path: {} success!", this.getAcls(), (Object)this.getPath());
            }
        } else {
            omMetrics.incNumBucketUpdateFails();
            if (exception == null) {
                LOG.error("Set acl {} for path {} failed", this.getAcls(), (Object)this.getPath());
            } else {
                LOG.error("Set acl {} for path {} failed!", new Object[]{this.getAcls(), this.getPath(), exception});
            }
        }
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        ozoneManager.getMetrics().incNumSetAcl();
        return super.validateAndUpdateCache(ozoneManager, trxnLogIndex, omDoubleBufferHelper);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMBucketSetAclRequest.java", OMBucketSetAclRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketSetAclRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 68);
    }
}

