/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket.acl;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.ObjectParser;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.acl.OMBucketAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.util.BooleanBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMBucketAclRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketAclRequest.class);
    private BooleanBiFunction<List<OzoneAcl>, OmBucketInfo> omBucketAclOp;

    public OMBucketAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BooleanBiFunction<List<OzoneAcl>, OmBucketInfo> aclOp) {
        super(omRequest);
        this.omBucketAclOp = aclOp;
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        boolean operationResult;
        IOException exception;
        OMClientResponse omClientResponse;
        List<OzoneAcl> ozoneAcls;
        block17: {
            ozoneAcls = this.getAcls();
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBucketUpdates();
            OmBucketInfo omBucketInfo = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            String volume = null;
            String bucket = null;
            operationResult = false;
            try {
                try {
                    ObjectParser objectParser = new ObjectParser(this.getPath(), OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET);
                    volume = objectParser.getVolume();
                    bucket = objectParser.getBucket();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
                    }
                    lockAcquired = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                    String dbBucketKey = omMetadataManager.getBucketKey(volume, bucket);
                    omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)dbBucketKey);
                    if (omBucketInfo == null) {
                        throw new OMException(OMException.ResultCodes.BUCKET_NOT_FOUND);
                    }
                    operationResult = this.omBucketAclOp.apply(ozoneAcls, (Object)omBucketInfo);
                    omBucketInfo.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
                    if (operationResult) {
                        long modificationTime = omBucketInfo.getModificationTime();
                        if (this.getOmRequest().getAddAclRequest().hasObj()) {
                            modificationTime = this.getOmRequest().getAddAclRequest().getModificationTime();
                        } else if (this.getOmRequest().getSetAclRequest().hasObj()) {
                            modificationTime = this.getOmRequest().getSetAclRequest().getModificationTime();
                        } else if (this.getOmRequest().getRemoveAclRequest().hasObj()) {
                            modificationTime = this.getOmRequest().getRemoveAclRequest().getModificationTime();
                        }
                        omBucketInfo = omBucketInfo.toBuilder().setModificationTime(modificationTime).build();
                        omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)dbBucketKey), new CacheValue(Optional.of((Object)omBucketInfo), transactionLogIndex));
                    }
                    omClientResponse = this.onSuccess(omResponse, omBucketInfo, operationResult);
                }
                catch (IOException ex) {
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, ex);
                    this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                    if (lockAcquired) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (lockAcquired) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (lockAcquired) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
            }
        }
        OzoneObj obj = this.getObject();
        Map auditMap = obj.toAuditMap();
        if (ozoneAcls != null) {
            auditMap.put("acl", ozoneAcls.toString());
        }
        this.onComplete(operationResult, exception, ozoneManager.getMetrics(), ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    abstract List<OzoneAcl> getAcls();

    abstract String getPath();

    abstract OzoneObj getObject();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmBucketInfo var2, boolean var3);

    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, IOException exception) {
        return new OMBucketAclResponse(this.createErrorOMResponse(omResponse, exception));
    }

    abstract void onComplete(boolean var1, IOException var2, OMMetrics var3, AuditLogger var4, Map<String, String> var5);
}

